/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.util.UUID;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.services.PunishmentService;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnbanCommand
implements CommandExecutor {
    private final PunishmentService punishmentService;

    public UnbanCommand(WeGuardian plugin, PunishmentService punishmentService) {
        this.punishmentService = punishmentService;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("weguardian.unban")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(MessageUtils.colorize("&cUsage: /unban <player>"));
            return true;
        }
        String targetName = args[0].trim();
        String staffName = (sender instanceof Player ? sender.getName() : "Console").trim();
        UUID targetUuid = Bukkit.getOfflinePlayer((String)targetName).getUniqueId();
        this.punishmentService.unbanPlayer(targetUuid, targetName, staffName).thenAccept(success -> {
            String message = success != false ? "&aSuccessfully unbanned " + targetName : "&c" + targetName + " is not currently banned.";
            sender.sendMessage(MessageUtils.colorize(message));
        });
        return true;
    }
}

