/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.PlayerData;
import me.wethink.weGuardian.services.PunishmentService;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class UnbanIPCommand
implements CommandExecutor {
    private final PunishmentService punishmentService;
    private final WeGuardian plugin;

    public UnbanIPCommand(WeGuardian plugin, PunishmentService punishmentService) {
        this.plugin = plugin;
        this.punishmentService = punishmentService;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        String ipAddress;
        if (!sender.hasPermission("weguardian.unbanip")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(MessageUtils.colorize("&cUsage: /unbanip <ip|player>"));
            return true;
        }
        String target = args[0];
        if (this.isValidIP(target)) {
            ipAddress = target;
        } else {
            CompletableFuture<PlayerData> playerDataFuture = this.plugin.getDatabaseManager().getPlayerData(target);
            PlayerData playerData = playerDataFuture.join();
            if (playerData != null && playerData.getLastIP() != null) {
                ipAddress = playerData.getLastIP();
                sender.sendMessage(MessageUtils.colorize("&aFound IP &e" + ipAddress + " &afor player &e" + target + "."));
            } else {
                sender.sendMessage(MessageUtils.colorize("&cCould not find IP address for player &e" + target + "."));
                return true;
            }
        }
        ((CompletableFuture)this.punishmentService.unbanIP(ipAddress, sender.getName()).thenAccept(success -> {
            if (success.booleanValue()) {
                sender.sendMessage(MessageUtils.colorize("&aSuccessfully unbanned IP &e" + ipAddress));
            } else {
                sender.sendMessage(MessageUtils.colorize("&c" + ipAddress + " is not currently banned."));
            }
        })).exceptionally(throwable -> {
            sender.sendMessage(MessageUtils.colorize("&cError executing IP unban: " + throwable.getMessage()));
            return null;
        });
        return true;
    }

    private boolean isValidIP(String ip) {
        try {
            String[] parts = ip.split("\\.");
            if (parts.length != 4) {
                return false;
            }
            for (String part : parts) {
                int num = Integer.parseInt(part);
                if (num >= 0 && num <= 255) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

