/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.util.UUID;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.services.PunishmentService;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnmuteCommand
implements CommandExecutor {
    private final PunishmentService punishmentService;

    public UnmuteCommand(WeGuardian plugin, PunishmentService punishmentService) {
        this.punishmentService = punishmentService;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("weguardian.unmute")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(MessageUtils.colorize("&cUsage: /unmute <player>"));
            return true;
        }
        String targetName = args[0];
        String staffName = sender instanceof Player ? sender.getName() : "Console";
        UUID targetUuid = Bukkit.getOfflinePlayer((String)targetName).getUniqueId();
        this.punishmentService.unmutePlayer(targetUuid, targetName, staffName).thenAccept(success -> {
            String message = success != false ? "&aSuccessfully unmuted " + targetName : "&c" + targetName + " is not currently muted.";
            sender.sendMessage(MessageUtils.colorize(message));
        });
        return true;
    }
}

