/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.util.Arrays;
import java.util.UUID;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.services.PunishmentService;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarnCommand
implements CommandExecutor {
    private final PunishmentService punishmentService;

    public WarnCommand(WeGuardian plugin, PunishmentService punishmentService) {
        this.punishmentService = punishmentService;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String finalTargetName;
        if (!sender.hasPermission("weguardian.warn")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(MessageUtils.colorize("&cUsage: /warn <player> <reason>"));
            return true;
        }
        String targetName = args[0];
        String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null && !Bukkit.getOfflinePlayer((String)targetName).hasPlayedBefore()) {
            sender.sendMessage(MessageUtils.colorize("&cPlayer not found."));
            return true;
        }
        if (target != null) {
            finalTargetName = target.getName();
            if (target.hasPermission("weguardian.bypass")) {
                sender.sendMessage(MessageUtils.colorize("&cYou cannot punish this player!"));
                return true;
            }
        } else {
            finalTargetName = targetName;
        }
        String staffName = sender instanceof Player ? sender.getName() : "Console";
        UUID targetUuid = target != null ? target.getUniqueId() : Bukkit.getOfflinePlayer((String)finalTargetName).getUniqueId();
        this.punishmentService.warnPlayer(targetUuid, finalTargetName, staffName, reason).thenAccept(success -> {
            String message = success != false ? "&aSuccessfully warned " + finalTargetName + " for: &e" + reason : "&cFailed to warn " + finalTargetName + ". Player may not exist.";
            sender.sendMessage(MessageUtils.colorize(message));
        });
        return true;
    }
}

