/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import me.wethink.weGuardian.utils.MessageUtils;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class WarnsCommand
implements CommandExecutor {
    private static final int ITEMS_PER_PAGE = 10;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final WeGuardian plugin;

    public WarnsCommand(WeGuardian plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!sender.hasPermission("weguardian.warns")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(MessageUtils.colorize("&cUsage: /warns <player> [page]"));
            return true;
        }
        String targetName = args[0];
        int page = 1;
        if (args.length > 1) {
            try {
                page = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(MessageUtils.colorize("&cInvalid page number: " + args[1]));
                return true;
            }
        }
        int finalPage = page;
        CompletableFuture<UUID> uuidFuture = this.plugin.getPunishmentService().getPlayerUUID(targetName);
        ((CompletableFuture)((CompletableFuture)uuidFuture.thenCompose(uuid -> {
            if (uuid == null) {
                sender.sendMessage(MessageUtils.colorize("&cPlayer '" + targetName + "' not found."));
                return CompletableFuture.completedFuture(null);
            }
            return this.plugin.getDatabaseManager().getPunishmentHistory((UUID)uuid);
        })).thenAccept(punishments -> {
            if (punishments == null) {
                return;
            }
            List warnings = punishments.stream().filter(p -> p.getType() == PunishmentType.WARN).sorted((a, b) -> b.getCreatedAt().compareTo(a.getCreatedAt())).collect(Collectors.toList());
            if (warnings.isEmpty()) {
                sender.sendMessage(MessageUtils.colorize("&aNo warnings found for player '" + targetName + "'."));
                return;
            }
            int totalPages = (int)Math.ceil((double)warnings.size() / 10.0);
            int startIndex = (finalPage - 1) * 10;
            int endIndex = Math.min(startIndex + 10, warnings.size());
            if (finalPage > totalPages) {
                sender.sendMessage(MessageUtils.colorize("&cPage " + finalPage + " does not exist. Maximum page: " + totalPages));
                return;
            }
            sender.sendMessage(MessageUtils.colorize("&6&l=== Warnings for " + targetName + " (Page " + finalPage + "/" + totalPages + ") ==="));
            sender.sendMessage(MessageUtils.colorize("&7Total warnings: &f" + warnings.size()));
            sender.sendMessage("");
            for (int i = startIndex; i < endIndex; ++i) {
                Punishment warning = (Punishment)warnings.get(i);
                BuildableComponent warningInfo = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)(i + 1 + ". ")).color(MessageUtils.parseColor("&7")))).append(Component.text((String)("ID: " + warning.getId())).color(MessageUtils.parseColor("&e")))).append(Component.text((String)" | ").color(MessageUtils.parseColor("&8")))).append(Component.text((String)warning.getCreatedAt().format(DATE_FORMAT)).color(MessageUtils.parseColor("&7")))).build();
                BuildableComponent hoverText = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"Warning ID: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)("" + warning.getId())).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nTarget: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)targetName).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nStaff: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)warning.getStaffName()).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nReason: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)warning.getReason()).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nDate: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)warning.getCreatedAt().format(DATE_FORMAT)).color(MessageUtils.parseColor("&f")))).build();
                if (!warning.isActive() && warning.getRemovedBy() != null) {
                    hoverText = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"Warning ID: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)("" + warning.getId())).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nTarget: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)targetName).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nStaff: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)warning.getStaffName()).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nReason: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)warning.getReason()).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nDate: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)warning.getCreatedAt().format(DATE_FORMAT)).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nRemoved By: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)warning.getRemovedBy()).color(MessageUtils.parseColor("&f")))).build();
                }
                warningInfo = warningInfo.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverText)).clickEvent(ClickEvent.suggestCommand((String)("/rollback " + warning.getId())));
                sender.sendMessage((Component)warningInfo);
                sender.sendMessage(MessageUtils.colorize("   &7Reason: &f" + warning.getReason()));
                sender.sendMessage(MessageUtils.colorize("   &7Staff: &f" + warning.getStaffName()));
                if (warning.isActive()) {
                    sender.sendMessage(MessageUtils.colorize("   &7Status: &aActive"));
                } else {
                    String removedBy = warning.getRemovedBy() != null ? warning.getRemovedBy() : "System";
                    sender.sendMessage(MessageUtils.colorize("   &7Status: &cRemoved by " + removedBy));
                }
                sender.sendMessage("");
            }
            TextComponent footer = Component.text((String)"");
            if (finalPage > 1) {
                footer = ((TextComponent)((TextComponent)Component.text((String)"[\u25c0 Previous]").color(MessageUtils.parseColor("&a"))).clickEvent(ClickEvent.runCommand((String)("/warns " + targetName + " " + (finalPage - 1))))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Go to page " + (finalPage - 1)))));
            }
            footer = Component.text((String)(" Page " + finalPage + "/" + totalPages + " ")).color(MessageUtils.parseColor("&7"));
            if (finalPage < totalPages) {
                footer = ((TextComponent)((TextComponent)Component.text((String)"[Next \u25b6]").color(MessageUtils.parseColor("&a"))).clickEvent(ClickEvent.runCommand((String)("/warns " + targetName + " " + (finalPage + 1))))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Go to page " + (finalPage + 1)))));
            }
            sender.sendMessage((Component)footer);
            sender.sendMessage(MessageUtils.colorize("&7Click on a warning ID to view blame information."));
        })).exceptionally(throwable -> {
            sender.sendMessage(MessageUtils.colorize("&cError retrieving warnings: " + throwable.getMessage()));
            this.plugin.getLogger().severe("Error in warns command: " + throwable.getMessage());
            return null;
        });
        return true;
    }
}

