/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands.subcommands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Description;
import co.aikar.commands.annotation.Syntax;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.command.CommandSender;

@CommandAlias(value="weguardian|wg")
@Description(value="Shows the plugin version and server information.")
@CommandPermission(value="weguardian.version")
public class VersionCommand
extends BaseCommand {
    private final WeGuardian plugin;

    public VersionCommand(WeGuardian plugin) {
        this.plugin = plugin;
    }

    @CommandAlias(value="version")
    @Syntax(value="")
    public void onVersion(CommandSender sender) {
        sender.sendMessage(MessageUtils.colorize("&6WeGuardian &7v" + this.plugin.getPluginMeta().getVersion()));
        sender.sendMessage(MessageUtils.colorize("&7Running on: &f" + this.plugin.getServer().getName() + " " + this.plugin.getServer().getVersion()));
        sender.sendMessage(MessageUtils.colorize("&7Java Version: &f" + System.getProperty("java.version")));
        String dbType = this.plugin.getConfig().getBoolean("database.mysql.enabled", false) ? "MySQL" : "SQLite";
        sender.sendMessage(MessageUtils.colorize("&7Database: &f" + dbType));
        boolean placeholderAPI = this.plugin.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI");
        sender.sendMessage(MessageUtils.colorize("&7PlaceholderAPI: " + (placeholderAPI ? "&aEnabled" : "&cDisabled")));
    }
}

