/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.gui;

import java.util.ArrayList;
import java.util.List;
import me.wethink.weGuardian.utils.MessageUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class MenuItem {
    private final Material material;
    private final List<Integer> slots;
    private final String name;
    private final List<String> lore;
    private final String skullOwner;
    private final String action;
    private final String reason;
    private final String duration;
    private final boolean customInput;

    public MenuItem(Material material, List<Integer> slots, String name, List<String> lore, String skullOwner, String action, String reason, String duration, boolean customInput) {
        this.material = material;
        this.slots = slots;
        this.name = name;
        this.lore = lore;
        this.skullOwner = skullOwner;
        this.action = action;
        this.reason = reason;
        this.duration = duration;
        this.customInput = customInput;
    }

    public static MenuItem fromConfig(ConfigurationSection config, String targetPlayer) {
        Material material;
        if (config == null) {
            return null;
        }
        String materialName = config.getString("material", "STONE");
        try {
            material = Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        ArrayList<Integer> slots = new ArrayList<Integer>();
        if (config.contains("slot")) {
            slots.add(config.getInt("slot"));
        }
        if (config.contains("slots")) {
            slots.addAll(config.getIntegerList("slots"));
        }
        if (slots.isEmpty()) {
            return null;
        }
        String name = config.getString("name", "Item");
        name = MessageUtils.colorize(name.replace("{player}", targetPlayer));
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : config.getStringList("lore")) {
            lore.add(MessageUtils.colorize(line.replace("{player}", targetPlayer)));
        }
        String skullOwner = null;
        if (material == Material.PLAYER_HEAD && config.contains("skull-owner")) {
            skullOwner = config.getString("skull-owner", targetPlayer).replace("{player}", targetPlayer);
        }
        String action = config.getString("action", "");
        String reason = config.getString("reason", config.getString("default-reason", ""));
        String duration = config.getString("duration", config.getString("time", ""));
        boolean customInput = config.getBoolean("custom", false) || config.getBoolean("custom-reason", false);
        return new MenuItem(material, slots, name, lore, skullOwner, action, reason, duration, customInput);
    }

    public ItemStack getItemStack() {
        ItemStack item = new ItemStack(this.material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName((Component)Component.text((String)this.name));
            ArrayList<TextComponent> componentLore = new ArrayList<TextComponent>();
            for (String line : this.lore) {
                componentLore.add(Component.text((String)line));
            }
            meta.lore(componentLore);
            if (this.material == Material.PLAYER_HEAD && this.skullOwner != null && meta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)meta;
                skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)this.skullOwner));
                meta = skullMeta;
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public Material getMaterial() {
        return this.material;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public String getSkullOwner() {
        return this.skullOwner;
    }

    public String getAction() {
        return this.action;
    }

    public String getReason() {
        return this.reason;
    }

    public String getDuration() {
        return this.duration;
    }

    public boolean isCustomInput() {
        return this.customInput;
    }

    public boolean isReasonItem() {
        return this.action.equals("reason") || this.action.startsWith("reason_") || !this.reason.isEmpty() || this.isCommonReasonAction();
    }

    public boolean isDurationItem() {
        return this.action.equals("duration") || this.action.startsWith("duration_") || this.action.startsWith("time_") || !this.duration.isEmpty() || this.action.matches("\\d+[hdwmy]");
    }

    public boolean isConfirmAction() {
        return this.action.equals("confirm") || this.action.equals("execute") || this.action.equals("apply");
    }

    public boolean isBackAction() {
        return this.action.equals("back") || this.action.equals("cancel") || this.action.equals("return");
    }

    public boolean isCloseAction() {
        return this.action.equals("close") || this.action.equals("exit");
    }

    private boolean isCommonReasonAction() {
        return this.action.equals("cheating") || this.action.equals("griefing") || this.action.equals("toxicity") || this.action.equals("spam") || this.action.equals("advertising") || this.action.equals("exploiting") || this.action.equals("doxxing") || this.action.equals("harassment") || this.action.equals("inappropriate");
    }
}

