/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.gui.menus;

import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.gui.MenuHandler;
import me.wethink.weGuardian.gui.menus.MenuManager;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class UnmuteMenu
extends MenuHandler {
    private final MenuManager menuManager;

    public UnmuteMenu(WeGuardian plugin, MenuManager menuManager) {
        super(plugin, "unmute");
        this.menuManager = menuManager;
    }

    @Override
    protected ConfigurationSection getMenuConfig() {
        return this.plugin.getGUIConfigLoader().getGUIConfig("unmute");
    }

    @Override
    protected void handleItemClick(Player staff, String targetPlayer, String itemKey, ConfigurationSection itemConfig) {
        String[] parts;
        String action = itemConfig.getString("action", "");
        if (action.startsWith("execute_punishment:") && (parts = action.split(":", 3)).length >= 2) {
            this.executeUnmute(staff, targetPlayer);
            return;
        }
        if (action.equals("back") || itemKey.equals("back")) {
            this.menuManager.setActiveMenu(staff, this.menuManager.getMainMenu());
            this.menuManager.getMainMenu().openMenu(staff, targetPlayer);
            return;
        }
        if (action.equals("close") || itemKey.equals("close")) {
            staff.closeInventory();
            return;
        }
        if (action.equals("confirm") || itemKey.equals("confirm") || itemKey.equals("unmute")) {
            this.executeUnmute(staff, targetPlayer);
            return;
        }
        this.executeUnmute(staff, targetPlayer);
    }

    private void executeUnmute(Player staff, String targetPlayer) {
        staff.closeInventory();
        this.clearSelectedData(staff);
        staff.sendMessage(MessageUtils.colorize("&eExecuting unmute on &a" + targetPlayer));
        ((CompletableFuture)this.plugin.getPunishmentService().unmute(targetPlayer, staff.getName()).thenAccept(success -> {
            if (success.booleanValue()) {
                staff.sendMessage(MessageUtils.colorize("&aSuccessfully unmuted " + targetPlayer));
            } else {
                staff.sendMessage(MessageUtils.colorize("&cFailed to unmute " + targetPlayer + ". Player may not be muted."));
            }
        })).exceptionally(throwable -> {
            this.plugin.getLogger().severe("Error executing unmute: " + throwable.getMessage());
            staff.sendMessage(MessageUtils.colorize("&cAn error occurred while executing the unmute."));
            return null;
        });
    }

    @Override
    protected void onMenuOpen(Player staff, String targetPlayer) {
        if (this.plugin.getConfig().getBoolean("debug.enabled", false)) {
            this.plugin.debug("Staff %s opened unmute menu for %s", staff.getName(), targetPlayer);
        }
    }
}

