/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.listeners;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.database.DatabaseManager;
import me.wethink.weGuardian.models.PlayerData;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import me.wethink.weGuardian.utils.MessageUtils;
import me.wethink.weguardian.lib.folialib.FoliaLib;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListener
implements Listener {
    private final WeGuardian plugin;
    private final DatabaseManager databaseManager;
    private final FoliaLib foliaLib;
    private final Map<String, Punishment> pendingMuteActions = new ConcurrentHashMap<String, Punishment>();

    public PlayerListener(WeGuardian plugin, DatabaseManager databaseManager) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
        this.foliaLib = plugin.getFoliaLib();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onAsyncPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        this.plugin.debug("Player pre-login event: %s (%s) from %s", event.getName(), event.getUniqueId(), event.getAddress().getHostAddress());
        if (event.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.plugin.debug("Player pre-login skipped: login result not allowed - %s", event.getName());
            return;
        }
        try {
            this.checkPunishmentsSync(event);
            if (event.getLoginResult() == AsyncPlayerPreLoginEvent.Result.ALLOWED) {
                this.checkIPBanSync(event);
                if (event.getLoginResult() == AsyncPlayerPreLoginEvent.Result.ALLOWED) {
                    this.foliaLib.getScheduler().runAsync(task -> {
                        try {
                            this.handlePlayerDataAsync(event);
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().severe("Error handling player data for " + event.getName() + ": " + e.getMessage());
                            e.printStackTrace();
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Critical error in pre-login processing for " + event.getName() + ": " + e.getMessage());
            e.printStackTrace();
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, MessageUtils.toComponent("&c&lCONNECTION ERROR\n&7An error occurred during login verification.\n&7Please try again later."));
        }
    }

    private void handlePlayerDataAsync(AsyncPlayerPreLoginEvent event) {
        try {
            PlayerData playerData = this.databaseManager.getPlayerData(event.getUniqueId()).join();
            if (playerData == null) {
                this.plugin.debug("Creating new player data for: %s", event.getName());
                playerData = new PlayerData(event.getUniqueId(), event.getName(), event.getAddress().getHostAddress());
                this.databaseManager.savePlayerData(playerData);
            } else {
                this.plugin.debug("Updating existing player data for: %s", event.getName());
                playerData.setName(event.getName());
                playerData.setIpAddress(event.getAddress().getHostAddress());
                playerData.updateLastSeen();
                this.databaseManager.savePlayerData(playerData);
            }
            this.databaseManager.recordPlayerConnection(event.getUniqueId(), event.getName(), event.getAddress().getHostAddress());
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error handling player data for " + event.getName() + ": " + e.getMessage());
        }
    }

    private void checkPunishmentsSync(AsyncPlayerPreLoginEvent event) {
        try {
            List<Punishment> punishments = this.databaseManager.getActivePunishments(event.getUniqueId()).join();
            this.plugin.debug("Checking %d active punishments for player: %s", punishments.size(), event.getName());
            if (punishments == null) {
                this.plugin.getLogger().warning("Database returned null punishments for " + event.getName() + " - denying access for safety");
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, MessageUtils.toComponent("&c&lCONNECTION ERROR\n&7Unable to verify your punishment status.\n&7Please try again later."));
                return;
            }
            for (Punishment punishment : punishments) {
                if (punishment == null) {
                    this.plugin.debug("Skipping null punishment for %s", event.getName());
                    continue;
                }
                if (!punishment.isActive()) {
                    this.plugin.debug("Skipping inactive punishment for %s", event.getName());
                    continue;
                }
                if (punishment.isExpired()) {
                    this.plugin.debug("Punishment expired for %s, skipping", event.getName());
                    continue;
                }
                this.plugin.debug("Found active punishment: type=%s, active=%s, expired=%s, target=%s", new Object[]{punishment.getType(), punishment.isActive(), punishment.isExpired(), punishment.getTargetName()});
                if (punishment.getType() == PunishmentType.BAN || punishment.getType() == PunishmentType.TEMPBAN) {
                    this.plugin.debug("Player %s is banned, blocking connection", event.getName());
                    String kickMessage = this.getBanMessage(punishment);
                    Component kickComponent = MessageUtils.toComponent(kickMessage);
                    event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, kickComponent);
                    this.plugin.getNotificationService().broadcastPunishment(punishment, "reconnect_attempt");
                    return;
                }
                if (punishment.getType() != PunishmentType.MUTE && punishment.getType() != PunishmentType.TEMPMUTE) continue;
                this.pendingMuteActions.put(event.getUniqueId().toString(), punishment);
                this.plugin.debug("Player %s is muted, will show action bar after join", event.getName());
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error checking punishments for " + event.getName() + ": " + e.getMessage());
            e.printStackTrace();
            this.plugin.getLogger().warning("Denying access to " + event.getName() + " due to punishment check failure");
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, MessageUtils.toComponent("&c&lCONNECTION ERROR\n&7Unable to verify your punishment status.\n&7Please try again later."));
        }
    }

    private void checkIPBanSync(AsyncPlayerPreLoginEvent event) {
        try {
            String playerIP = event.getAddress().getHostAddress();
            Boolean isIPBanned = this.databaseManager.isIPBanned(playerIP).join();
            if (isIPBanned == null) {
                this.plugin.getLogger().warning("Database returned null for IP ban check for " + event.getName() + " (" + playerIP + ") - denying access for safety");
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, MessageUtils.toComponent("&c&lCONNECTION ERROR\n&7Unable to verify IP ban status.\n&7Please try again later."));
                return;
            }
            if (isIPBanned.booleanValue()) {
                String ipBanMessage = this.plugin.getMessage("screen.ipban", "&c&l&m====================\n&c&lIP BANNED\n&7&m====================\n\n&7Your IP address has been banned from this server.\n&7IP: &f" + playerIP + "\n\n&7Appeal at: &e{appeal-url}\n&7&m====================");
                String appealUrl = this.plugin.getAppealUrl();
                ipBanMessage = appealUrl != null && !appealUrl.isEmpty() ? ipBanMessage.replace("{appeal-url}", appealUrl) : ipBanMessage.replace("&7Appeal at: &e{appeal-url}\n", "");
                Component kickComponent = MessageUtils.toComponent(ipBanMessage);
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, kickComponent);
                if (this.plugin.getConfig().getBoolean("debug.enabled", false)) {
                    this.plugin.getLogger().info("Blocked IP banned connection attempt from " + playerIP + " (" + event.getName() + ")");
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error checking IP ban for " + event.getName() + ": " + e.getMessage());
            e.printStackTrace();
            this.plugin.getLogger().warning("Denying access to " + event.getName() + " due to IP ban check failure");
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, MessageUtils.toComponent("&c&lCONNECTION ERROR\n&7Unable to verify IP ban status.\n&7Please try again later."));
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        String playerUuid = event.getPlayer().getUniqueId().toString();
        Punishment mutePunishment = this.pendingMuteActions.remove(playerUuid);
        if (mutePunishment != null) {
            this.foliaLib.getScheduler().runAtEntity((Entity)event.getPlayer(), task -> {
                String actionBarMessage = this.getMuteMessage(mutePunishment);
                if (!actionBarMessage.isEmpty()) {
                    Component component = MessageUtils.toComponent(actionBarMessage);
                    event.getPlayer().sendActionBar(component);
                }
            });
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        String playerUuid = event.getPlayer().getUniqueId().toString();
        this.pendingMuteActions.remove(playerUuid);
        this.foliaLib.getScheduler().runAsync(task -> {
            try {
                PlayerData playerData = this.databaseManager.getPlayerData(event.getPlayer().getUniqueId()).join();
                if (playerData != null) {
                    playerData.updateLastSeen();
                    this.databaseManager.savePlayerData(playerData);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error updating last seen for " + event.getPlayer().getName() + ": " + e.getMessage());
            }
        });
        this.plugin.getPunishmentGUI().cleanupPlayer(event.getPlayer());
    }

    private String getBanMessage(Punishment punishment) {
        String template = switch (punishment.getType()) {
            case PunishmentType.BAN -> this.plugin.getMessage("screen.ban", "&c&l&m====================\n&c&lYOU ARE BANNED\n&7&m====================\n\n&7Reason: &f{reason}\n&7Staff: &f{staff}\n&7Date: &f{datetime}\n&7Duration: &f{duration}\n\n&7Appeal at: &e{appeal-url}\n&7&m====================");
            case PunishmentType.TEMPBAN -> this.plugin.getMessage("screen.tempban", "&e&l&m====================\n&e&lTEMPORARY BAN\n&7&m====================\n\n&7Reason: &f{reason}\n&7Staff: &f{staff}\n&7Date: &f{datetime}\n&7Expires: &f{expires}\n&7Time Left: &f{time-left}\n\n&7Appeal at: &e{appeal-url}\n&7&m====================");
            default -> "&c&lYOU ARE BANNED\n&7You have been banned from this server.";
        };
        String appealUrl = this.plugin.getAppealUrl();
        if (appealUrl != null && !appealUrl.isEmpty()) {
            return MessageUtils.formatPunishmentMessage(template, punishment, appealUrl);
        }
        return MessageUtils.formatPunishmentMessage(template, punishment);
    }

    private String getMuteMessage(Punishment punishment) {
        String template;
        switch (punishment.getType()) {
            case MUTE: {
                String string = this.plugin.getMessage("actionbar.mute", "&c&lMUTED &8| &7Reason: &f{reason} &8| &7Staff: &f{staff}");
                break;
            }
            case TEMPMUTE: {
                String string = this.plugin.getMessage("actionbar.tempmute", "&e&lTEMPORARILY MUTED &8| &7Time Left: &f{time-left} &8| &7Reason: &f{reason}");
                break;
            }
            default: {
                String string = template = "";
            }
        }
        if (template.isEmpty()) {
            return "";
        }
        return MessageUtils.formatPunishmentMessage(template, punishment);
    }
}

