/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.managers;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final WeGuardian plugin;
    private FileConfiguration messagesConfig;
    private int loadedMessagesCount = 0;

    public MessageManager(WeGuardian plugin) {
        this.plugin = plugin;
        this.loadMessagesConfig();
    }

    private void loadMessagesConfig() {
        try {
            File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
            if (!messagesFile.exists()) {
                this.plugin.saveResource("messages.yml", false);
                this.plugin.debug("Created default messages.yml file");
            }
            this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
            this.countLoadedMessages();
            this.plugin.debug("Loaded " + this.loadedMessagesCount + " messages from messages.yml");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load messages.yml", e);
            this.messagesConfig = new YamlConfiguration();
        }
    }

    private void countLoadedMessages() {
        this.loadedMessagesCount = 0;
        if (this.messagesConfig != null) {
            this.countSection("screen");
            this.countSection("actionbar");
            this.countSection("chat");
            this.countSection("defaults");
            this.countSection("commands");
            this.countSection("errors");
        }
    }

    private void countSection(String section) {
        if (this.messagesConfig.getConfigurationSection(section) != null) {
            this.loadedMessagesCount += this.messagesConfig.getConfigurationSection(section).getKeys(true).size();
        }
    }

    public void reloadMessages() {
        this.loadMessagesConfig();
        this.plugin.debug("Messages configuration reloaded");
    }

    public String getMessage(String path) {
        return this.getMessage(path, "");
    }

    public String getMessage(String path, String defaultMessage) {
        if (this.messagesConfig == null) {
            return defaultMessage;
        }
        return this.messagesConfig.getString(path, defaultMessage);
    }

    public List<String> getMessageList(String path) {
        if (this.messagesConfig == null) {
            return List.of();
        }
        return this.messagesConfig.getStringList(path);
    }

    public String getKickMessage(Punishment punishment) {
        String messageKey = "screen." + punishment.getType().name().toLowerCase();
        String template = this.getMessage(messageKey, this.getDefaultKickMessage(punishment.getType()));
        return MessageUtils.formatPunishmentMessage(template, punishment);
    }

    public String getActionBarMessage(Punishment punishment) {
        String messageKey = "actionbar." + punishment.getType().name().toLowerCase();
        String template = this.getMessage(messageKey, this.getDefaultActionBarMessage(punishment.getType()));
        return MessageUtils.formatPunishmentMessage(template, punishment);
    }

    public String getChatBroadcastMessage(Punishment punishment) {
        String messageKey = "chat." + punishment.getType().name().toLowerCase();
        String template = this.getMessage(messageKey, this.getDefaultChatMessage(punishment.getType()));
        return MessageUtils.formatPunishmentMessage(template, punishment);
    }

    public String getUnpunishmentMessage(Punishment punishment, String staffName) {
        String messageKey = "chat.un" + punishment.getType().name().toLowerCase();
        String template = this.getMessage(messageKey, this.getDefaultUnpunishmentMessage(punishment.getType()));
        return template.replace("{player}", punishment.getTargetName()).replace("{staff}", staffName);
    }

    public String getCommandMessage(String key) {
        return this.getMessage("commands." + key, "&cMessage not found: " + key);
    }

    public String getErrorMessage(String key) {
        return this.getMessage("errors." + key, "&cError message not found: " + key);
    }

    public String getUsageMessage(String command) {
        return this.getMessage("commands.usage." + command, "&cUsage not found for command: " + command);
    }

    private String getDefaultKickMessage(PunishmentType type) {
        return switch (type) {
            case PunishmentType.BAN -> "&c&l\u26a0 YOU ARE BANNED \u26a0\n\n&7Reason: &f{reason}\n&7Staff: &f{staff}\n&7Date: &f{date}";
            case PunishmentType.TEMPBAN -> "&e&l\u23f0 TEMPORARY BAN \u23f0\n\n&7Reason: &f{reason}\n&7Staff: &f{staff}\n&7Expires: &f{expires}";
            case PunishmentType.KICK -> "&c&l\u26a1 KICKED \u26a1\n\n&7Reason: &f{reason}\n&7Staff: &f{staff}";
            case PunishmentType.WARN -> "&e\u26a0 &6You have been warned!\n&7Reason: &f{reason}\n&7Staff: &f{staff}";
            default -> "&cYou have been punished: {reason}";
        };
    }

    private String getDefaultActionBarMessage(PunishmentType type) {
        return switch (type) {
            case PunishmentType.MUTE -> "&6\ud83d\udd07 You are muted: &f{reason}";
            case PunishmentType.TEMPMUTE -> "&6\ud83d\udd07 Muted: &f{reason} &7| &fExpires: {time-left}";
            case PunishmentType.BAN -> "&c\u26a0 You are banned: &f{reason}";
            case PunishmentType.TEMPBAN -> "&e\u23f0 Temporarily banned: &f{reason} &7| &fExpires: {time-left}";
            default -> "&7You are punished: {reason}";
        };
    }

    private String getDefaultChatMessage(PunishmentType type) {
        return switch (type) {
            case PunishmentType.BAN -> "&c\u26a0 &f{player} &chas been banned by &f{staff} &cfor: &f{reason}";
            case PunishmentType.TEMPBAN -> "&e\u23f0 &f{player} &ehas been temporarily banned by &f{staff} &efor: &f{reason} &7({duration})";
            case PunishmentType.MUTE -> "&6\ud83d\udd07 &f{player} &6has been muted by &f{staff} &6for: &f{reason}";
            case PunishmentType.TEMPMUTE -> "&6\ud83d\udd07 &f{player} &6has been temporarily muted by &f{staff} &6for: &f{reason} &7({duration})";
            case PunishmentType.KICK -> "&c\u26a1 &f{player} &chas been kicked by &f{staff} &cfor: &f{reason}";
            case PunishmentType.WARN -> "&e\u26a0 &f{player} &ehas been warned by &f{staff} &efor: &f{reason}";
            default -> "&7{player} was punished by {staff} for: {reason}";
        };
    }

    private String getDefaultUnpunishmentMessage(PunishmentType type) {
        return switch (type) {
            case PunishmentType.BAN, PunishmentType.TEMPBAN -> "&a\u2713 &f{player} &ahas been unbanned by &f{staff}";
            case PunishmentType.MUTE, PunishmentType.TEMPMUTE -> "&a\u2713 &f{player} &ahas been unmuted by &f{staff}";
            default -> "&a\u2713 &f{player} &ahas been unpunished by &f{staff}";
        };
    }

    public int getLoadedMessagesCount() {
        return this.loadedMessagesCount;
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }
}

