/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.models;

import java.time.LocalDateTime;
import java.util.UUID;
import me.wethink.weGuardian.models.PunishmentType;

public class Punishment {
    private int id;
    private UUID targetUuid;
    private String targetName;
    private String targetIP;
    private UUID staffUuid;
    private String staffName;
    private PunishmentType type;
    private String reason;
    private LocalDateTime createdAt;
    private LocalDateTime expiresAt;
    private boolean active;
    private UUID removedByUuid;
    private String removedByName;
    private LocalDateTime removedAt;
    private String removalReason;
    private String serverName;

    public Punishment() {
    }

    public Punishment(UUID targetUuid, String targetName, UUID staffUuid, String staffName, PunishmentType type, String reason, LocalDateTime expiresAt, String serverName) {
        this.targetUuid = targetUuid;
        this.targetName = targetName;
        this.staffUuid = staffUuid;
        this.staffName = staffName;
        this.type = type;
        this.reason = reason;
        this.createdAt = LocalDateTime.now();
        this.expiresAt = expiresAt;
        this.active = true;
        this.serverName = serverName;
    }

    public Punishment(String targetIP, UUID staffUuid, String staffName, PunishmentType type, String reason, LocalDateTime expiresAt, String serverName) {
        this.targetIP = targetIP;
        this.targetName = targetIP;
        this.staffUuid = staffUuid;
        this.staffName = staffName;
        this.type = type;
        this.reason = reason;
        this.createdAt = LocalDateTime.now();
        this.expiresAt = expiresAt;
        this.active = true;
        this.serverName = serverName;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public UUID getTargetUuid() {
        return this.targetUuid;
    }

    public void setTargetUuid(UUID targetUuid) {
        this.targetUuid = targetUuid;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getTargetIP() {
        return this.targetIP;
    }

    public void setTargetIP(String targetIP) {
        this.targetIP = targetIP;
    }

    public UUID getStaffUuid() {
        return this.staffUuid;
    }

    public void setStaffUuid(UUID staffUuid) {
        this.staffUuid = staffUuid;
    }

    public String getStaffName() {
        return this.staffName;
    }

    public void setStaffName(String staffName) {
        this.staffName = staffName;
    }

    public PunishmentType getType() {
        return this.type;
    }

    public void setType(PunishmentType type) {
        this.type = type;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(LocalDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public UUID getRemovedByUuid() {
        return this.removedByUuid;
    }

    public void setRemovedByUuid(UUID removedByUuid) {
        this.removedByUuid = removedByUuid;
    }

    public String getRemovedByName() {
        return this.removedByName;
    }

    public void setRemovedByName(String removedByName) {
        this.removedByName = removedByName;
    }

    public String getRemovedBy() {
        return this.removedByName;
    }

    public void setRemovedBy(String removedBy) {
        this.removedByName = removedBy;
    }

    public LocalDateTime getRemovedAt() {
        return this.removedAt;
    }

    public void setRemovedAt(LocalDateTime removedAt) {
        this.removedAt = removedAt;
    }

    public String getRemovalReason() {
        return this.removalReason;
    }

    public void setRemovalReason(String removalReason) {
        this.removalReason = removalReason;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public boolean isExpired() {
        return this.expiresAt != null && LocalDateTime.now().isAfter(this.expiresAt);
    }

    public boolean isPermanent() {
        return this.expiresAt == null;
    }

    public boolean isIPBased() {
        return this.targetIP != null && !this.targetIP.isEmpty();
    }

    public String getDisplayTarget() {
        return this.isIPBased() ? this.targetIP : this.targetName;
    }

    public void remove(UUID removedBy, String removedByName, String reason) {
        this.active = false;
        this.removedByUuid = removedBy;
        this.removedByName = removedByName;
        this.removedAt = LocalDateTime.now();
        this.removalReason = reason;
    }
}

