/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TabCompletionUtils {
    public static List<String> getPlayerNameCompletions(String input, int maxResults) {
        if (input == null || input.isEmpty()) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).limit(maxResults).collect(Collectors.toList());
        }
        String lowerInput = input.toLowerCase();
        ArrayList<String> exactMatches = new ArrayList<String>();
        ArrayList<String> prefixMatches = new ArrayList<String>();
        ArrayList<String> containsMatches = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            String playerName = player.getName();
            String lowerPlayerName = playerName.toLowerCase();
            if (lowerPlayerName.equals(lowerInput)) {
                exactMatches.add(playerName);
                continue;
            }
            if (lowerPlayerName.startsWith(lowerInput)) {
                prefixMatches.add(playerName);
                continue;
            }
            if (!lowerPlayerName.contains(lowerInput)) continue;
            containsMatches.add(playerName);
        }
        prefixMatches.sort(String.CASE_INSENSITIVE_ORDER);
        containsMatches.sort(Comparator.comparingInt(name -> name.toLowerCase().indexOf(lowerInput)));
        ArrayList<String> result = new ArrayList<String>(exactMatches);
        result.addAll(prefixMatches);
        result.addAll(containsMatches);
        return result.stream().limit(maxResults).collect(Collectors.toList());
    }

    public static List<String> getPlayerNameCompletions(String input) {
        return TabCompletionUtils.getPlayerNameCompletions(input, 20);
    }
}

