/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.utils;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.database.DatabaseManager;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class WeGuardianPlaceholderExpansion
extends PlaceholderExpansion {
    private final WeGuardian plugin;
    private final DatabaseManager databaseManager;

    public WeGuardianPlaceholderExpansion(WeGuardian plugin, DatabaseManager databaseManager) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
    }

    @NotNull
    public String getIdentifier() {
        return "weguardian";
    }

    @NotNull
    public String getAuthor() {
        return "WeThink";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getPluginMeta().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (player == null) {
            return "";
        }
        if (params.equals("banned")) {
            CompletableFuture<Boolean> future = this.databaseManager.isPlayerBanned(player.getUniqueId());
            try {
                return future.get(1L, TimeUnit.SECONDS) != false ? "true" : "false";
            }
            catch (Exception e) {
                return "false";
            }
        }
        if (params.equals("muted")) {
            CompletableFuture<Boolean> future = this.databaseManager.isPlayerMuted(player.getUniqueId());
            try {
                return future.get(1L, TimeUnit.SECONDS) != false ? "true" : "false";
            }
            catch (Exception e) {
                return "false";
            }
        }
        if (params.equals("ban_reason")) {
            return this.getActivePunishmentInfo(player, PunishmentType.BAN, "reason");
        }
        if (params.equals("ban_staff")) {
            return this.getActivePunishmentInfo(player, PunishmentType.BAN, "staff");
        }
        if (params.equals("ban_expires")) {
            return this.getActivePunishmentInfo(player, PunishmentType.BAN, "expires");
        }
        if (params.equals("ban_time_left")) {
            return this.getActivePunishmentInfo(player, PunishmentType.BAN, "timeleft");
        }
        if (params.equals("tempban_reason")) {
            return this.getActivePunishmentInfo(player, PunishmentType.TEMPBAN, "reason");
        }
        if (params.equals("tempban_staff")) {
            return this.getActivePunishmentInfo(player, PunishmentType.TEMPBAN, "staff");
        }
        if (params.equals("tempban_expires")) {
            return this.getActivePunishmentInfo(player, PunishmentType.TEMPBAN, "expires");
        }
        if (params.equals("tempban_time_left")) {
            return this.getActivePunishmentInfo(player, PunishmentType.TEMPBAN, "timeleft");
        }
        if (params.equals("mute_reason")) {
            return this.getActivePunishmentInfo(player, PunishmentType.MUTE, "reason");
        }
        if (params.equals("mute_staff")) {
            return this.getActivePunishmentInfo(player, PunishmentType.MUTE, "staff");
        }
        if (params.equals("mute_expires")) {
            return this.getActivePunishmentInfo(player, PunishmentType.MUTE, "expires");
        }
        if (params.equals("mute_time_left")) {
            return this.getActivePunishmentInfo(player, PunishmentType.MUTE, "timeleft");
        }
        if (params.equals("tempmute_reason")) {
            return this.getActivePunishmentInfo(player, PunishmentType.TEMPMUTE, "reason");
        }
        if (params.equals("tempmute_staff")) {
            return this.getActivePunishmentInfo(player, PunishmentType.TEMPMUTE, "staff");
        }
        if (params.equals("tempmute_expires")) {
            return this.getActivePunishmentInfo(player, PunishmentType.TEMPMUTE, "expires");
        }
        if (params.equals("tempmute_time_left")) {
            return this.getActivePunishmentInfo(player, PunishmentType.TEMPMUTE, "timeleft");
        }
        if (params.equals("total_punishments")) {
            return this.getPunishmentCount(player, null);
        }
        if (params.equals("total_bans")) {
            return this.getPunishmentCount(player, PunishmentType.BAN);
        }
        if (params.equals("total_tempbans")) {
            return this.getPunishmentCount(player, PunishmentType.TEMPBAN);
        }
        if (params.equals("total_mutes")) {
            return this.getPunishmentCount(player, PunishmentType.MUTE);
        }
        if (params.equals("total_tempmutes")) {
            return this.getPunishmentCount(player, PunishmentType.TEMPMUTE);
        }
        if (params.equals("total_kicks")) {
            return this.getPunishmentCount(player, PunishmentType.KICK);
        }
        if (params.equals("total_warns")) {
            return this.getPunishmentCount(player, PunishmentType.WARN);
        }
        return null;
    }

    private String getActivePunishmentInfo(OfflinePlayer player, PunishmentType type, String info) {
        try {
            CompletableFuture<Punishment> future = this.databaseManager.getActivePunishment(player.getUniqueId(), type);
            Punishment punishment = future.get(1L, TimeUnit.SECONDS);
            if (punishment == null) {
                return "";
            }
            switch (info.toLowerCase()) {
                case "reason": {
                    return punishment.getReason();
                }
                case "staff": {
                    return punishment.getStaffName();
                }
                case "expires": {
                    if (punishment.getExpiresAt() == null) {
                        return "Never";
                    }
                    return this.formatTimestamp(punishment.getExpiresAt());
                }
                case "timeleft": {
                    if (punishment.getExpiresAt() == null) {
                        return "Permanent";
                    }
                    long timeLeft = punishment.getExpiresAt().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() - System.currentTimeMillis();
                    if (timeLeft <= 0L) {
                        return "Expired";
                    }
                    return this.formatDuration(timeLeft);
                }
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private String getPunishmentCount(OfflinePlayer player, PunishmentType type) {
        try {
            CompletableFuture<List<Punishment>> future = type == null ? this.databaseManager.getPunishmentHistory(player.getUniqueId()) : this.databaseManager.getPunishmentHistory(player.getUniqueId(), type);
            List<Punishment> punishments = future.get(1L, TimeUnit.SECONDS);
            return String.valueOf(punishments.size());
        }
        catch (Exception e) {
            return "0";
        }
    }

    private String formatTimestamp(LocalDateTime dateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return dateTime.format(formatter);
    }

    private String formatDuration(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + "d " + hours % 24L + "h";
        }
        if (hours > 0L) {
            return hours + "h " + minutes % 60L + "m";
        }
        if (minutes > 0L) {
            return minutes + "m " + seconds % 60L + "s";
        }
        return seconds + "s";
    }
}

