/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import me.wethink.weGuardian.WeGuardian;

public class RequestLoggingFilter
implements Filter {
    private final WeGuardian plugin;

    public RequestLoggingFilter(WeGuardian plugin) {
        this.plugin = plugin;
    }

    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest req = (HttpServletRequest)request;
                String ip = request.getRemoteAddr();
                String method = req.getMethod();
                String uri = req.getRequestURI();
                this.plugin.getLogger().info("[Web] " + ip + " -> " + method + " " + uri);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }
}

