/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.PlayerData;
import me.wethink.weGuardian.services.PunishmentService;
import me.wethink.weGuardian.services.TemplateService;
import me.wethink.weGuardian.utils.MessageUtils;
import me.wethink.weGuardian.utils.TimeUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class TempIPBanCommand
implements CommandExecutor,
TabCompleter {
    private final WeGuardian plugin;
    private final PunishmentService punishmentService;
    private final TemplateService templateService;

    public TempIPBanCommand(WeGuardian plugin, PunishmentService punishmentService) {
        this.plugin = plugin;
        this.punishmentService = punishmentService;
        this.templateService = plugin.getTemplateService();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        String ipAddress;
        if (!sender.hasPermission("weguardian.tempipban")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage(MessageUtils.colorize("&cUsage: /tempipban <ip|player> <duration> <reason> [-s] [-t template]"));
            sender.sendMessage(MessageUtils.colorize("&7Examples:"));
            sender.sendMessage(MessageUtils.colorize("&7  /tempipban 192.168.1.1 1d Griefing"));
            sender.sendMessage(MessageUtils.colorize("&7  /tempipban 10.0.0.1 2h Spam -s"));
            sender.sendMessage(MessageUtils.colorize("&7  /tempipban 127.0.0.1 1w Hacking -t cheating"));
            sender.sendMessage(MessageUtils.colorize("&7Options:"));
            sender.sendMessage(MessageUtils.colorize("&7  -s: Silent tempipban (no broadcast)"));
            sender.sendMessage(MessageUtils.colorize("&7  -t <template>: Use punishment template"));
            return true;
        }
        String target = args[0];
        String duration = args[1];
        boolean silent = Arrays.asList(args).contains("-s");
        String template = null;
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals("-t") || i + 1 >= args.length) continue;
            template = args[i + 1];
            break;
        }
        String finalTemplate = template;
        if (this.isValidIP(target)) {
            ipAddress = target;
        } else {
            CompletableFuture<PlayerData> playerDataFuture = this.plugin.getDatabaseManager().getPlayerData(target);
            PlayerData playerData = playerDataFuture.join();
            if (playerData != null && playerData.getLastIP() != null) {
                ipAddress = playerData.getLastIP();
                sender.sendMessage(MessageUtils.colorize("&aFound IP &e" + ipAddress + " &afor player &e" + target + "."));
            } else {
                sender.sendMessage(MessageUtils.colorize("&cCould not find IP address for player &e" + target + "."));
                return true;
            }
        }
        if (!TimeUtils.isValidTimeFormat(duration)) {
            sender.sendMessage(MessageUtils.colorize("&cInvalid time format. Use formats like: 1h, 2d, 1w, 1m, 1y"));
            return true;
        }
        ArrayList<String> reasonParts = new ArrayList<String>();
        for (int i = 2; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-s")) continue;
            if (arg.equals("-t")) {
                ++i;
                continue;
            }
            reasonParts.add(arg);
        }
        if (reasonParts.isEmpty()) {
            sender.sendMessage(MessageUtils.colorize("&cYou must provide a reason for the tempipban."));
            return true;
        }
        String reason = String.join((CharSequence)" ", reasonParts);
        String staffName = sender.getName();
        if (finalTemplate != null && this.templateService.hasTemplate(finalTemplate)) {
            this.templateService.executePunishmentFromTemplate(null, ipAddress, staffName, finalTemplate, duration).thenAccept(success -> {
                if (success.booleanValue()) {
                    sender.sendMessage(MessageUtils.colorize("&aSuccessfully applied template '" + finalTemplate + "' punishment to IP " + ipAddress + " for " + duration));
                } else {
                    sender.sendMessage(MessageUtils.colorize("&cFailed to apply template punishment."));
                }
            });
        } else {
            ((CompletableFuture)this.punishmentService.ipTempban(ipAddress, staffName, reason, duration).thenAccept(success -> {
                if (success.booleanValue()) {
                    String message = "&aSuccessfully IP tempbanned &e" + ipAddress + " &afor " + duration + ": &f" + reason;
                    if (silent) {
                        message = message + " &7(Silent)";
                    }
                    sender.sendMessage(MessageUtils.colorize(message));
                    this.plugin.getLogger().info(staffName + " IP tempbanned " + ipAddress + " for " + duration + ": " + reason + (silent ? " (Silent)" : ""));
                } else {
                    sender.sendMessage(MessageUtils.colorize("&cFailed to IP tempban " + ipAddress + ". Please check the IP address."));
                }
            })).exceptionally(throwable -> {
                sender.sendMessage(MessageUtils.colorize("&cError executing IP tempban: " + throwable.getMessage()));
                return null;
            });
        }
        return true;
    }

    private boolean isValidIP(String ip) {
        try {
            String[] parts = ip.split("\\.");
            if (parts.length != 4) {
                return false;
            }
            for (String part : parts) {
                int num = Integer.parseInt(part);
                if (num >= 0 && num <= 255) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("192.168.", "10.0.", "127.0.0.1"));
        } else if (args.length == 2) {
            completions.addAll(Arrays.asList("1h", "6h", "12h", "1d", "3d", "1w", "1m"));
        } else if (args.length == 3) {
            completions.addAll(Arrays.asList("Hacking", "Griefing", "Inappropriate behavior", "Spam"));
        } else if (args.length == 4) {
            completions.add("-s");
            completions.add("-t");
        }
        return completions;
    }
}

