/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.database;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.database.DatabaseManager;
import me.wethink.weGuardian.models.BanwaveEntry;
import me.wethink.weGuardian.models.PlayerData;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import me.wethink.weguardian.lib.hikari.HikariConfig;
import me.wethink.weguardian.lib.hikari.HikariDataSource;
import org.bukkit.configuration.file.FileConfiguration;

public class HikariDatabaseManager
implements DatabaseManager {
    private final WeGuardian plugin;
    private final boolean useMySQL;
    private final ExecutorService executorService;
    private HikariDataSource dataSource;

    public HikariDatabaseManager(WeGuardian plugin) {
        this.plugin = plugin;
        this.executorService = Executors.newFixedThreadPool(2);
        FileConfiguration config = plugin.getConfig();
        this.useMySQL = config.getBoolean("database.mysql.enabled", false);
    }

    @Override
    public CompletableFuture<Void> initialize() {
        return this.connect().thenCompose(success -> {
            if (success.booleanValue()) {
                return this.createTables();
            }
            return CompletableFuture.failedFuture(new RuntimeException("Failed to connect to database"));
        });
    }

    @Override
    public CompletableFuture<Boolean> connect() {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block10: {
                HikariConfig config = new HikariConfig();
                if (this.useMySQL) {
                    this.setupMySQLConfig(config);
                } else {
                    this.setupSQLiteConfig(config);
                }
                this.dataSource = new HikariDataSource(config);
                Connection conn = this.dataSource.getConnection();
                try {
                    bl = conn.isValid(5);
                    if (conn == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Failed to connect to database", e);
                        return false;
                    }
                }
                conn.close();
            }
            return bl;
        });
    }

    private void setupMySQLConfig(HikariConfig config) {
        FileConfiguration pluginConfig = this.plugin.getConfig();
        String host = pluginConfig.getString("database.mysql.host", "localhost");
        int port = pluginConfig.getInt("database.mysql.port", 3306);
        String database = pluginConfig.getString("database.mysql.database", "weguardian");
        String username = pluginConfig.getString("database.mysql.username", "root");
        String password = pluginConfig.getString("database.mysql.password", "");
        config.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=false&serverTimezone=UTC");
        config.setUsername(username);
        config.setPassword(password);
        config.setDriverClassName("com.mysql.cj.jdbc.Driver");
        config.setMaximumPoolSize(10);
        config.setMinimumIdle(2);
        config.setConnectionTimeout(30000L);
        config.setIdleTimeout(600000L);
        config.setMaxLifetime(1800000L);
    }

    private void setupSQLiteConfig(HikariConfig config) {
        File dataFolder = this.plugin.getDataFolder();
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        File dbFile = new File(dataFolder, "weguardian.db");
        config.setJdbcUrl("jdbc:sqlite:" + dbFile.getAbsolutePath());
        config.setDriverClassName("org.sqlite.JDBC");
        config.setMaximumPoolSize(1);
        config.setConnectionTimeout(30000L);
    }

    private String getNowFunction() {
        return this.useMySQL ? "NOW()" : "CURRENT_TIMESTAMP";
    }

    @Override
    public CompletableFuture<Void> createTables() {
        return CompletableFuture.runAsync(() -> {
            try (Connection conn = this.dataSource.getConnection();){
                this.createPlayersTable(conn);
                this.createPunishmentsTable(conn);
                this.createBanwaveTable(conn);
                this.createPlayerConnectionsTable(conn);
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to create tables", e);
            }
        });
    }

    private void createPlayersTable(Connection conn) throws SQLException {
        String sql = this.useMySQL ? "CREATE TABLE IF NOT EXISTS wg_players (uuid VARCHAR(36) PRIMARY KEY,name VARCHAR(16) NOT NULL,ip_address VARCHAR(45),first_join TIMESTAMP DEFAULT CURRENT_TIMESTAMP,last_seen TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,banned BOOLEAN DEFAULT FALSE,muted BOOLEAN DEFAULT FALSE,INDEX idx_name (name))" : "CREATE TABLE IF NOT EXISTS wg_players (uuid TEXT PRIMARY KEY,name TEXT NOT NULL,ip_address TEXT,first_join TIMESTAMP DEFAULT CURRENT_TIMESTAMP,last_seen TIMESTAMP DEFAULT CURRENT_TIMESTAMP,banned INTEGER DEFAULT 0,muted INTEGER DEFAULT 0)";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.executeUpdate();
        }
    }

    private void createPunishmentsTable(Connection conn) throws SQLException {
        String sql = this.useMySQL ? "CREATE TABLE IF NOT EXISTS wg_punishments (id INT AUTO_INCREMENT PRIMARY KEY,target_uuid VARCHAR(36) NOT NULL,target_name VARCHAR(16) NOT NULL,staff_uuid VARCHAR(36) NOT NULL,staff_name VARCHAR(16) NOT NULL,type VARCHAR(20) NOT NULL,reason TEXT NOT NULL,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,expires_at TIMESTAMP NULL,active BOOLEAN DEFAULT TRUE,removed_by_uuid VARCHAR(36) NULL,removed_by_name VARCHAR(16) NULL,removed_at TIMESTAMP NULL,removal_reason TEXT NULL,server_name VARCHAR(50) NOT NULL,INDEX idx_target (target_uuid),INDEX idx_staff (staff_uuid),INDEX idx_type (type),INDEX idx_active (active))" : "CREATE TABLE IF NOT EXISTS wg_punishments (id INTEGER PRIMARY KEY AUTOINCREMENT,target_uuid TEXT NOT NULL,target_name TEXT NOT NULL,staff_uuid TEXT NOT NULL,staff_name TEXT NOT NULL,type TEXT NOT NULL,reason TEXT NOT NULL,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,expires_at TIMESTAMP NULL,active INTEGER DEFAULT 1,removed_by_uuid TEXT NULL,removed_by_name TEXT NULL,removed_at TIMESTAMP NULL,removal_reason TEXT NULL,server_name TEXT NOT NULL)";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.executeUpdate();
        }
    }

    private void createBanwaveTable(Connection conn) throws SQLException {
        String sql = this.useMySQL ? "CREATE TABLE IF NOT EXISTS wg_banwave (id INT AUTO_INCREMENT PRIMARY KEY,target_uuid VARCHAR(36) NOT NULL,target_name VARCHAR(16) NOT NULL,staff_uuid VARCHAR(36) NOT NULL,staff_name VARCHAR(16) NOT NULL,reason TEXT NOT NULL,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,executed BOOLEAN DEFAULT FALSE,executed_at TIMESTAMP NULL,INDEX idx_executed (executed))" : "CREATE TABLE IF NOT EXISTS wg_banwave (id INTEGER PRIMARY KEY AUTOINCREMENT,target_uuid TEXT NOT NULL,target_name TEXT NOT NULL,staff_uuid TEXT NOT NULL,staff_name TEXT NOT NULL,reason TEXT NOT NULL,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,executed INTEGER DEFAULT 0,executed_at TIMESTAMP NULL)";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.executeUpdate();
        }
    }

    private void createPlayerConnectionsTable(Connection conn) throws SQLException {
        String sql = this.useMySQL ? "CREATE TABLE IF NOT EXISTS wg_player_connections (player_uuid VARCHAR(36) NOT NULL,player_name VARCHAR(16) NOT NULL,ip_address VARCHAR(45) NOT NULL,last_seen TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,PRIMARY KEY (player_uuid, ip_address),INDEX idx_player (player_uuid),INDEX idx_ip (ip_address))" : "CREATE TABLE IF NOT EXISTS wg_player_connections (player_uuid TEXT NOT NULL,player_name TEXT NOT NULL,ip_address TEXT NOT NULL,last_seen TIMESTAMP DEFAULT CURRENT_TIMESTAMP,PRIMARY KEY (player_uuid, ip_address))";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.executeUpdate();
        }
    }

    @Override
    public CompletableFuture<Void> disconnect() {
        return CompletableFuture.runAsync(() -> {
            if (this.dataSource != null && !this.dataSource.isClosed()) {
                this.dataSource.close();
            }
        });
    }

    @Override
    public CompletableFuture<PlayerData> getPlayerData(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT * FROM wg_players WHERE uuid = ?";
            try (Connection conn = this.dataSource.getConnection();){
                PlayerData playerData;
                block18: {
                    PreparedStatement stmt;
                    block16: {
                        PlayerData playerData2;
                        block17: {
                            stmt = conn.prepareStatement(sql);
                            try {
                                stmt.setString(1, uuid.toString());
                                ResultSet rs = stmt.executeQuery();
                                if (!rs.next()) break block16;
                                playerData2 = this.mapPlayerData(rs);
                                if (stmt == null) break block17;
                            }
                            catch (Throwable throwable) {
                                if (stmt != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            stmt.close();
                        }
                        return playerData2;
                    }
                    playerData = null;
                    if (stmt == null) break block18;
                    stmt.close();
                }
                return playerData;
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to get player data", e);
                return null;
            }
        });
    }

    @Override
    public CompletableFuture<PlayerData> getPlayerData(String name) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT * FROM wg_players WHERE name = ? ORDER BY last_seen DESC LIMIT 1";
            try (Connection conn = this.dataSource.getConnection();){
                PlayerData playerData;
                block18: {
                    PreparedStatement stmt;
                    block16: {
                        PlayerData playerData2;
                        block17: {
                            stmt = conn.prepareStatement(sql);
                            try {
                                stmt.setString(1, name);
                                ResultSet rs = stmt.executeQuery();
                                if (!rs.next()) break block16;
                                playerData2 = this.mapPlayerData(rs);
                                if (stmt == null) break block17;
                            }
                            catch (Throwable throwable) {
                                if (stmt != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            stmt.close();
                        }
                        return playerData2;
                    }
                    playerData = null;
                    if (stmt == null) break block18;
                    stmt.close();
                }
                return playerData;
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to get player data by name", e);
                return null;
            }
        });
    }

    private PlayerData mapPlayerData(ResultSet rs) throws SQLException {
        Timestamp lastSeen;
        PlayerData data = new PlayerData();
        data.setUuid(UUID.fromString(rs.getString("uuid")));
        data.setName(rs.getString("name"));
        data.setIpAddress(rs.getString("ip_address"));
        Timestamp firstJoin = rs.getTimestamp("first_join");
        if (firstJoin != null) {
            data.setFirstJoin(firstJoin.toLocalDateTime());
        }
        if ((lastSeen = rs.getTimestamp("last_seen")) != null) {
            data.setLastSeen(lastSeen.toLocalDateTime());
        }
        data.setBanned(rs.getBoolean("banned"));
        data.setMuted(rs.getBoolean("muted"));
        return data;
    }

    @Override
    public CompletableFuture<Void> savePlayerData(PlayerData playerData) {
        return CompletableFuture.runAsync(() -> {
            String sql = this.useMySQL ? "INSERT INTO wg_players (uuid, name, ip_address, first_join, last_seen, banned, muted) VALUES (?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE name = VALUES(name), ip_address = VALUES(ip_address), last_seen = VALUES(last_seen), banned = VALUES(banned), muted = VALUES(muted)" : "INSERT OR REPLACE INTO wg_players (uuid, name, ip_address, first_join, last_seen, banned, muted) VALUES (?, ?, ?, ?, ?, ?, ?)";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, playerData.getUuid().toString());
                stmt.setString(2, playerData.getName());
                stmt.setString(3, playerData.getIpAddress());
                stmt.setTimestamp(4, Timestamp.valueOf(playerData.getFirstJoin()));
                stmt.setTimestamp(5, Timestamp.valueOf(playerData.getLastSeen()));
                stmt.setBoolean(6, playerData.isBanned());
                stmt.setBoolean(7, playerData.isMuted());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to save player data", e);
            }
        });
    }

    @Override
    public CompletableFuture<Integer> addPunishment(Punishment punishment) {
        return CompletableFuture.supplyAsync(() -> {
            this.plugin.debug("Adding punishment to database: type=%s, target=%s, staff=%s", new Object[]{punishment.getType(), punishment.getTargetName(), punishment.getStaffName()});
            String sql = "INSERT INTO wg_punishments (target_uuid, target_name, staff_uuid, staff_name, type, reason, created_at, expires_at, active, server_name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            try (Connection conn = this.dataSource.getConnection();){
                Integer n;
                block20: {
                    PreparedStatement stmt;
                    block18: {
                        Integer n2;
                        block19: {
                            stmt = conn.prepareStatement(sql, 1);
                            try {
                                stmt.setString(1, punishment.getTargetUuid() != null ? punishment.getTargetUuid().toString() : null);
                                stmt.setString(2, punishment.getTargetName());
                                stmt.setString(3, punishment.getStaffUuid() != null ? punishment.getStaffUuid().toString() : null);
                                stmt.setString(4, punishment.getStaffName());
                                stmt.setString(5, punishment.getType().name());
                                stmt.setString(6, punishment.getReason());
                                stmt.setTimestamp(7, Timestamp.valueOf(punishment.getCreatedAt()));
                                if (punishment.getExpiresAt() != null) {
                                    stmt.setTimestamp(8, Timestamp.valueOf(punishment.getExpiresAt()));
                                    this.plugin.debug("Punishment has expiration: %s", punishment.getExpiresAt());
                                } else {
                                    stmt.setNull(8, 93);
                                    this.plugin.debug("Punishment is permanent");
                                }
                                stmt.setBoolean(9, punishment.isActive());
                                stmt.setString(10, punishment.getServerName());
                                this.plugin.debug("Executing SQL insert for punishment");
                                stmt.executeUpdate();
                                ResultSet keys = stmt.getGeneratedKeys();
                                if (!keys.next()) break block18;
                                int id = keys.getInt(1);
                                this.plugin.debug("Punishment added to database with ID: %d", id);
                                n2 = id;
                                if (stmt == null) break block19;
                            }
                            catch (Throwable throwable) {
                                if (stmt != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            stmt.close();
                        }
                        return n2;
                    }
                    this.plugin.debug("Failed to get generated key for punishment");
                    n = -1;
                    if (stmt == null) break block20;
                    stmt.close();
                }
                return n;
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to add punishment", e);
                this.plugin.debug("SQL error adding punishment: %s", e.getMessage());
                return -1;
            }
        });
    }

    @Override
    public CompletableFuture<List<Punishment>> getActivePunishments(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT * FROM wg_punishments WHERE target_uuid = ? AND active = ? AND (expires_at IS NULL OR expires_at > ?)";
            try (Connection conn = this.dataSource.getConnection();){
                ArrayList<Punishment> arrayList;
                block15: {
                    PreparedStatement stmt = conn.prepareStatement(sql);
                    try {
                        stmt.setString(1, uuid.toString());
                        stmt.setBoolean(2, true);
                        stmt.setTimestamp(3, Timestamp.valueOf(LocalDateTime.now()));
                        ResultSet rs = stmt.executeQuery();
                        ArrayList<Punishment> punishments = new ArrayList<Punishment>();
                        while (rs.next()) {
                            punishments.add(this.mapPunishment(rs));
                        }
                        arrayList = punishments;
                        if (stmt == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return arrayList;
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to get active punishments", e);
                return new ArrayList();
            }
        });
    }

    private Punishment mapPunishment(ResultSet rs) throws SQLException {
        Punishment punishment = new Punishment();
        punishment.setId(rs.getInt("id"));
        punishment.setTargetUuid(UUID.fromString(rs.getString("target_uuid")));
        punishment.setTargetName(rs.getString("target_name"));
        punishment.setStaffUuid(UUID.fromString(rs.getString("staff_uuid")));
        punishment.setStaffName(rs.getString("staff_name"));
        punishment.setType(PunishmentType.valueOf(rs.getString("type")));
        punishment.setReason(rs.getString("reason"));
        punishment.setCreatedAt(rs.getTimestamp("created_at").toLocalDateTime());
        Timestamp expiresAt = rs.getTimestamp("expires_at");
        if (expiresAt != null) {
            punishment.setExpiresAt(expiresAt.toLocalDateTime());
        }
        punishment.setActive(rs.getBoolean("active"));
        punishment.setServerName(rs.getString("server_name"));
        String removedByUuid = rs.getString("removed_by_uuid");
        if (removedByUuid != null) {
            punishment.setRemovedByUuid(UUID.fromString(removedByUuid));
            punishment.setRemovedByName(rs.getString("removed_by_name"));
            Timestamp removedAt = rs.getTimestamp("removed_at");
            if (removedAt != null) {
                punishment.setRemovedAt(removedAt.toLocalDateTime());
            }
            punishment.setRemovalReason(rs.getString("removal_reason"));
        }
        return punishment;
    }

    @Override
    public CompletableFuture<Integer> getStaffPunishmentCount(UUID staffUuid, PunishmentType type) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Override
    public CompletableFuture<Integer> getTotalPunishmentCount(PunishmentType type) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Override
    public CompletableFuture<List<Punishment>> getRecentPunishments(int limit) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Punishment> punishments = new ArrayList<Punishment>();
            String sql = "SELECT * FROM wg_punishments ORDER BY created_at DESC LIMIT ?";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setInt(1, limit);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        punishments.add(this.mapPunishment(rs));
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error getting recent punishments: " + e.getMessage());
            }
            return punishments;
        });
    }

    @Override
    public CompletableFuture<Integer> addBanwaveEntry(BanwaveEntry entry) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "INSERT INTO wg_banwave (target_uuid, target_name, staff_uuid, staff_name, reason, created_at, executed) VALUES (?, ?, ?, ?, ?, ?, ?)";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql, 1);){
                stmt.setString(1, entry.getTargetUuid().toString());
                stmt.setString(2, entry.getTargetName());
                stmt.setString(3, entry.getStaffUuid().toString());
                stmt.setString(4, entry.getStaffName());
                stmt.setString(5, entry.getReason());
                stmt.setTimestamp(6, Timestamp.valueOf(entry.getCreatedAt()));
                stmt.setBoolean(7, entry.isExecuted());
                int affectedRows = stmt.executeUpdate();
                if (affectedRows <= 0) return -1;
                try (ResultSet generatedKeys = stmt.getGeneratedKeys();){
                    if (!generatedKeys.next()) return -1;
                    Integer n = generatedKeys.getInt(1);
                    return n;
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error adding banwave entry: " + e.getMessage());
            }
            return -1;
        });
    }

    @Override
    public CompletableFuture<List<BanwaveEntry>> getPendingBanwaveEntries() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<BanwaveEntry> entries = new ArrayList<BanwaveEntry>();
            String sql = "SELECT * FROM wg_banwave WHERE executed = 0 ORDER BY created_at ASC";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    entries.add(this.resultSetToBanwaveEntry(rs));
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error getting pending banwave entries: " + e.getMessage());
            }
            return entries;
        });
    }

    @Override
    public CompletableFuture<Void> executeBanwaveEntry(int id) {
        return CompletableFuture.runAsync(() -> {
            String sql = "UPDATE wg_banwave SET executed = 1 WHERE id = ?";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setInt(1, id);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error executing banwave entry: " + e.getMessage());
            }
        });
    }

    @Override
    public CompletableFuture<Void> removeBanwaveEntry(int id) {
        return CompletableFuture.runAsync(() -> {
            String sql = "DELETE FROM wg_banwave WHERE id = ?";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setInt(1, id);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error removing banwave entry: " + e.getMessage());
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> isPlayerBanned(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Override
    public CompletableFuture<Boolean> isPlayerMuted(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Override
    public CompletableFuture<List<String>> searchPlayers(String query) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<String> results = new ArrayList<String>();
            String sql = "SELECT DISTINCT player_name FROM wg_punishments WHERE player_name LIKE ? LIMIT 10";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, "%" + query + "%");
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString("player_name"));
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Failed to search players: " + e.getMessage());
            }
            return results;
        }, this.executorService);
    }

    @Override
    public CompletableFuture<List<PlayerData>> searchPlayersByName(String name) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<PlayerData> results = new ArrayList<PlayerData>();
            String sql = "SELECT uuid, name, ip_address, first_join, last_seen, banned, muted FROM wg_players WHERE name LIKE ? ORDER BY last_seen DESC LIMIT 10";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, "%" + name + "%");
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    UUID uuid = UUID.fromString(rs.getString("uuid"));
                    String playerName = rs.getString("name");
                    String ipAddress = rs.getString("ip_address");
                    LocalDateTime firstJoin = rs.getTimestamp("first_join").toLocalDateTime();
                    LocalDateTime lastSeen = rs.getTimestamp("last_seen").toLocalDateTime();
                    boolean banned = rs.getBoolean("banned");
                    boolean muted = rs.getBoolean("muted");
                    PlayerData playerData = new PlayerData(uuid, playerName, ipAddress);
                    playerData.setFirstJoin(firstJoin);
                    playerData.setLastSeen(lastSeen);
                    playerData.setBanned(banned);
                    playerData.setMuted(muted);
                    results.add(playerData);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Failed to search players by name: " + e.getMessage());
            }
            return results;
        }, this.executorService);
    }

    @Override
    public CompletableFuture<Integer> getTotalPunishments() {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, this.executorService);
    }

    @Override
    public CompletableFuture<List<DatabaseManager.PlayerConnection>> getPlayerConnections(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<PlayerConnectionImpl> connections = new ArrayList<PlayerConnectionImpl>();
            String query = "SELECT player_uuid, player_name, ip_address, last_seen FROM wg_player_connections WHERE player_uuid = ? ORDER BY last_seen DESC";
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(query);){
                statement.setString(1, uuid.toString());
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    UUID playerUuid = UUID.fromString(resultSet.getString("player_uuid"));
                    String playerName = resultSet.getString("player_name");
                    String ipAddress = resultSet.getString("ip_address");
                    LocalDateTime timestamp = resultSet.getTimestamp("last_seen").toLocalDateTime();
                    connections.add(new PlayerConnectionImpl(playerUuid, playerName, ipAddress, timestamp));
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error getting player connections for UUID: " + String.valueOf(uuid), e);
            }
            return connections;
        }, this.executorService);
    }

    @Override
    public CompletableFuture<List<DatabaseManager.PlayerConnection>> getPlayersFromIP(String ip) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<PlayerConnectionImpl> players = new ArrayList<PlayerConnectionImpl>();
            String query = "SELECT player_uuid, player_name, ip_address, last_seen FROM wg_player_connections WHERE ip_address = ? ORDER BY last_seen DESC";
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(query);){
                statement.setString(1, ip);
                try (ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        UUID playerUuid = UUID.fromString(resultSet.getString("player_uuid"));
                        String playerName = resultSet.getString("player_name");
                        String ipAddress = resultSet.getString("ip_address");
                        LocalDateTime timestamp = resultSet.getTimestamp("last_seen").toLocalDateTime();
                        players.add(new PlayerConnectionImpl(playerUuid, playerName, ipAddress, timestamp));
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error getting players from IP: " + e.getMessage());
            }
            return players;
        }, this.executorService);
    }

    @Override
    public CompletableFuture<Void> recordPlayerConnection(UUID uuid, String playerName, String ip) {
        return CompletableFuture.runAsync(() -> {
            String query = "INSERT INTO wg_player_connections (player_uuid, player_name, ip_address, last_seen) VALUES (?, ?, ?, " + this.getNowFunction() + ") ON DUPLICATE KEY UPDATE player_name = VALUES(player_name), last_seen = VALUES(last_seen)";
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(query);){
                statement.setString(1, uuid.toString());
                statement.setString(2, playerName);
                statement.setString(3, ip);
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error recording player connection: " + e.getMessage());
            }
        }, this.executorService);
    }

    @Override
    public CompletableFuture<List<Punishment>> getAllActivePunishments() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Punishment> punishments = new ArrayList<Punishment>();
            String sql = "SELECT * FROM wg_punishments WHERE active = 1 AND (expires_at IS NULL OR expires_at > " + this.getNowFunction() + ") ORDER BY created_at DESC";
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(sql);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    punishments.add(this.mapResultSetToPunishment(resultSet));
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error getting all active punishments: " + e.getMessage());
            }
            return punishments;
        }, this.executorService);
    }

    private Punishment mapResultSetToPunishment(ResultSet resultSet) throws SQLException {
        Punishment punishment = new Punishment();
        punishment.setId(resultSet.getInt("id"));
        punishment.setTargetUuid(UUID.fromString(resultSet.getString("target_uuid")));
        punishment.setTargetName(resultSet.getString("target_name"));
        punishment.setStaffUuid(UUID.fromString(resultSet.getString("staff_uuid")));
        punishment.setStaffName(resultSet.getString("staff_name"));
        punishment.setType(PunishmentType.valueOf(resultSet.getString("type")));
        punishment.setReason(resultSet.getString("reason"));
        punishment.setCreatedAt(resultSet.getTimestamp("created_at").toLocalDateTime());
        Timestamp expiresAt = resultSet.getTimestamp("expires_at");
        if (expiresAt != null) {
            punishment.setExpiresAt(expiresAt.toLocalDateTime());
        }
        punishment.setActive(resultSet.getBoolean("active"));
        punishment.setServerName(resultSet.getString("server_name"));
        String removedByUuid = resultSet.getString("removed_by_uuid");
        if (removedByUuid != null) {
            punishment.setRemovedByUuid(UUID.fromString(removedByUuid));
            punishment.setRemovedByName(resultSet.getString("removed_by_name"));
            Timestamp removedAt = resultSet.getTimestamp("removed_at");
            if (removedAt != null) {
                punishment.setRemovedAt(removedAt.toLocalDateTime());
            }
            punishment.setRemovalReason(resultSet.getString("removal_reason"));
        }
        return punishment;
    }

    @Override
    public CompletableFuture<Punishment> getPunishment(int id) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT * FROM wg_punishments WHERE id = ?";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setInt(1, id);
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) return null;
                    Punishment punishment = this.mapPunishment(rs);
                    return punishment;
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error getting punishment: " + e.getMessage());
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<List<Punishment>> getPunishmentHistory(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Punishment> punishments = new ArrayList<Punishment>();
            String sql = "SELECT * FROM wg_punishments WHERE target_uuid = ? ORDER BY created_at DESC";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, uuid.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        punishments.add(this.mapPunishment(rs));
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error getting punishment history: " + e.getMessage());
            }
            return punishments;
        });
    }

    @Override
    public CompletableFuture<List<Punishment>> getPunishmentHistory(UUID uuid, PunishmentType type) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Punishment> punishments = new ArrayList<Punishment>();
            String sql = "SELECT * FROM wg_punishments WHERE target_uuid = ? AND type = ? ORDER BY created_at DESC";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, uuid.toString());
                stmt.setString(2, type.name());
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        punishments.add(this.mapPunishment(rs));
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error getting punishment history by type: " + e.getMessage());
            }
            return punishments;
        });
    }

    @Override
    public CompletableFuture<Punishment> getActivePunishment(UUID uuid, PunishmentType type) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT * FROM wg_punishments WHERE target_uuid = ? AND type = ? AND active = 1 AND (expires_at IS NULL OR expires_at > " + this.getNowFunction() + ") ORDER BY created_at DESC LIMIT 1";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, uuid.toString());
                stmt.setString(2, type.name());
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) return null;
                    Punishment punishment = this.mapPunishment(rs);
                    return punishment;
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error getting active punishment: " + e.getMessage());
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> removePunishment(int id, UUID removedBy, String removedByName, String reason) {
        return CompletableFuture.runAsync(() -> {
            String sql = "UPDATE wg_punishments SET active = 0, removed_by_uuid = ?, removed_by_name = ?, removed_at = " + this.getNowFunction() + ", removal_reason = ? WHERE id = ?";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, removedBy.toString());
                stmt.setString(2, removedByName);
                stmt.setString(3, reason);
                stmt.setInt(4, id);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error removing punishment: " + e.getMessage());
            }
        });
    }

    @Override
    public CompletableFuture<Void> expirePunishments() {
        return CompletableFuture.runAsync(() -> {
            String sql = "UPDATE wg_punishments SET active = 0 WHERE active = 1 AND expires_at IS NOT NULL AND expires_at <= " + this.getNowFunction();
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                int updated = stmt.executeUpdate();
                if (updated > 0) {
                    this.plugin.getLogger().info("Expired " + updated + " punishments");
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error expiring punishments: " + e.getMessage());
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> isIPMuted(String ip) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT COUNT(*) FROM wg_punishments WHERE target_ip = ? AND type = 'IPMUTE' AND active = 1 AND (expires_at IS NULL OR expires_at > " + this.getNowFunction() + ")";
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, ip);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (!resultSet.next()) return false;
                    Boolean bl = resultSet.getInt(1) > 0;
                    return bl;
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error checking IP mute status for " + ip + ": " + e.getMessage());
            }
            return false;
        }, this.executorService);
    }

    @Override
    public CompletableFuture<Boolean> isIPBanned(String ip) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT COUNT(*) FROM wg_punishments WHERE target_ip = ? AND type IN ('IPBAN', 'IPTEMPBAN') AND active = 1 AND (expires_at IS NULL OR expires_at > " + this.getNowFunction() + ")";
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, ip);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (!resultSet.next()) return false;
                    Boolean bl = resultSet.getInt(1) > 0;
                    return bl;
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error checking IP ban status for " + ip + ": " + e.getMessage());
            }
            return false;
        }, this.executorService);
    }

    @Override
    public void close() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }

    private BanwaveEntry resultSetToBanwaveEntry(ResultSet rs) throws SQLException {
        return new BanwaveEntry(rs.getInt("id"), UUID.fromString(rs.getString("target_uuid")), rs.getString("target_name"), UUID.fromString(rs.getString("staff_uuid")), rs.getString("staff_name"), rs.getString("reason"), rs.getTimestamp("created_at").toLocalDateTime(), rs.getBoolean("executed"));
    }

    @Override
    public CompletableFuture<Punishment> getPunishmentById(int id) {
        return this.getPunishment(id);
    }

    @Override
    public CompletableFuture<List<Punishment>> getPunishmentsByType(UUID uuid, PunishmentType type) {
        return this.getPunishmentHistory(uuid, type);
    }

    @Override
    public CompletableFuture<List<Punishment>> getPunishmentsByStaff(String staffName) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Punishment> punishments = new ArrayList<Punishment>();
            String sql = "SELECT * FROM wg_punishments WHERE staff_name = ? ORDER BY created_at DESC";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, staffName);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        punishments.add(this.mapPunishment(rs));
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error getting punishments by staff: " + e.getMessage());
            }
            return punishments;
        });
    }

    @Override
    public CompletableFuture<List<Punishment>> getAllPunishments() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Punishment> punishments = new ArrayList<Punishment>();
            String sql = "SELECT * FROM wg_punishments ORDER BY created_at DESC";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    punishments.add(this.mapPunishment(rs));
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error getting all punishments: " + e.getMessage());
            }
            return punishments;
        });
    }

    @Override
    public CompletableFuture<Void> updatePlayerName(UUID uuid, String newName) {
        return CompletableFuture.runAsync(() -> {
            String sql = "UPDATE wg_players SET name = ? WHERE uuid = ?";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, newName);
                stmt.setString(2, uuid.toString());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error updating player name: " + e.getMessage());
            }
        }, this.executorService);
    }

    private static class PlayerConnectionImpl
    implements DatabaseManager.PlayerConnection {
        private final UUID uuid;
        private final String playerName;
        private final String ip;
        private final LocalDateTime timestamp;

        public PlayerConnectionImpl(UUID uuid, String playerName, String ip, LocalDateTime timestamp) {
            this.uuid = uuid;
            this.playerName = playerName;
            this.ip = ip;
            this.timestamp = timestamp;
        }

        @Override
        public UUID getUuid() {
            return this.uuid;
        }

        @Override
        public String getPlayerName() {
            return this.playerName;
        }

        @Override
        public String getIp() {
            return this.ip;
        }

        @Override
        public LocalDateTime getTimestamp() {
            return this.timestamp;
        }
    }
}

