/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.gui.menus;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.gui.MenuHandler;
import me.wethink.weGuardian.gui.menus.BanMenu;
import me.wethink.weGuardian.gui.menus.KickMenu;
import me.wethink.weGuardian.gui.menus.MainMenu;
import me.wethink.weGuardian.gui.menus.MuteMenu;
import me.wethink.weGuardian.gui.menus.NotesMenu;
import me.wethink.weGuardian.gui.menus.TempbanMenu;
import me.wethink.weGuardian.gui.menus.TempmuteMenu;
import me.wethink.weGuardian.gui.menus.UnbanMenu;
import me.wethink.weGuardian.gui.menus.UnmuteMenu;
import me.wethink.weGuardian.gui.menus.WarnMenu;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.plugin.Plugin;

public class MenuManager
implements Listener {
    private final WeGuardian plugin;
    private final Map<Player, MenuHandler> activeMenus = new HashMap<Player, MenuHandler>();
    private final MainMenu mainMenu;
    private final BanMenu banMenu;
    private final TempbanMenu tempbanMenu;
    private final MuteMenu muteMenu;
    private final TempmuteMenu tempmuteMenu;
    private final KickMenu kickMenu;
    private final WarnMenu warnMenu;
    private final NotesMenu notesMenu;
    private final UnbanMenu unbanMenu;
    private final UnmuteMenu unmuteMenu;
    private static final Pattern COLOR_CODES = Pattern.compile("\u00a7[0-9a-fk-or]");
    private static final Set<String> KNOWN_MENU_TITLES = Set.of("Ban Menu", "Mute Menu", "Kick Menu", "Warn Menu", "Tempban Menu", "Tempmute Menu", "Unban Menu", "Unmute Menu", "Notes Menu", "Punishment");

    public MenuManager(WeGuardian plugin) {
        this.plugin = plugin;
        this.mainMenu = new MainMenu(plugin, this);
        this.banMenu = new BanMenu(plugin, this);
        this.tempbanMenu = new TempbanMenu(plugin, this);
        this.muteMenu = new MuteMenu(plugin, this);
        this.tempmuteMenu = new TempmuteMenu(plugin, this);
        this.kickMenu = new KickMenu(plugin, this);
        this.warnMenu = new WarnMenu(plugin, this);
        this.notesMenu = new NotesMenu(plugin, this);
        this.unbanMenu = new UnbanMenu(plugin, this);
        this.unmuteMenu = new UnmuteMenu(plugin, this);
        this.mainMenu.setMenuManager(this);
        this.banMenu.setMenuManager(this);
        this.tempbanMenu.setMenuManager(this);
        this.muteMenu.setMenuManager(this);
        this.tempmuteMenu.setMenuManager(this);
        this.kickMenu.setMenuManager(this);
        this.warnMenu.setMenuManager(this);
        this.notesMenu.setMenuManager(this);
        this.unbanMenu.setMenuManager(this);
        this.unmuteMenu.setMenuManager(this);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openMainMenu(Player staff, String targetPlayer) {
        this.activeMenus.put(staff, this.mainMenu);
        this.mainMenu.openMenu(staff, targetPlayer);
    }

    public void openMenu(Player staff, String targetPlayer, String menuType) {
        MenuHandler menu = this.getMenuByType(menuType);
        if (menu != null) {
            this.activeMenus.put(staff, menu);
            menu.openMenu(staff, targetPlayer);
        } else {
            staff.sendMessage("\u00a7cUnknown menu type: " + menuType);
        }
    }

    private MenuHandler getMenuByType(String menuType) {
        return switch (menuType.toLowerCase()) {
            case "main" -> this.mainMenu;
            case "ban" -> this.banMenu;
            case "tempban" -> this.tempbanMenu;
            case "mute" -> this.muteMenu;
            case "tempmute" -> this.tempmuteMenu;
            case "kick" -> this.kickMenu;
            case "warn" -> this.warnMenu;
            case "notes" -> this.notesMenu;
            case "unban" -> this.unbanMenu;
            case "unmute" -> this.unmuteMenu;
            default -> null;
        };
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        MenuHandler activeMenu = this.activeMenus.get(player);
        if (activeMenu != null) {
            event.setCancelled(true);
            activeMenu.handleClick(event, event.getSlot());
            return;
        }
        Component componentTitle = event.getView().title();
        String plainTitle = PlainTextComponentSerializer.plainText().serialize(componentTitle);
        String strippedTitle = COLOR_CODES.matcher(plainTitle).replaceAll("");
        if (this.isWeGuardianGUI(strippedTitle)) {
            event.setCancelled(true);
            MenuHandler recoveredMenu = this.findMenuByTitle(strippedTitle);
            if (recoveredMenu != null) {
                String targetPlayer = this.extractTargetPlayerFromTitle(strippedTitle);
                if (targetPlayer != null) {
                    recoveredMenu.setTargetPlayer(player, targetPlayer);
                }
                this.activeMenus.put(player, recoveredMenu);
                recoveredMenu.handleClick(event, event.getSlot());
            } else {
                this.plugin.debug("Failed to recover WeGuardian menu with title: %s", strippedTitle);
            }
        }
    }

    private boolean isWeGuardianGUI(String title) {
        for (String keyword : KNOWN_MENU_TITLES) {
            if (!title.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    private MenuHandler findMenuByTitle(String strippedTitle) {
        if (strippedTitle.contains("Ban Menu")) {
            return this.banMenu;
        }
        if (strippedTitle.contains("Tempban Menu")) {
            return this.tempbanMenu;
        }
        if (strippedTitle.contains("Mute Menu")) {
            return this.muteMenu;
        }
        if (strippedTitle.contains("Tempmute Menu")) {
            return this.tempmuteMenu;
        }
        if (strippedTitle.contains("Kick Menu")) {
            return this.kickMenu;
        }
        if (strippedTitle.contains("Warn Menu")) {
            return this.warnMenu;
        }
        if (strippedTitle.contains("Unban Menu")) {
            return this.unbanMenu;
        }
        if (strippedTitle.contains("Unmute Menu")) {
            return this.unmuteMenu;
        }
        if (strippedTitle.contains("Notes Menu")) {
            return this.notesMenu;
        }
        if (strippedTitle.contains("Punishment")) {
            return this.mainMenu;
        }
        return null;
    }

    private String extractTargetPlayerFromTitle(String strippedTitle) {
        int pipeIndex = strippedTitle.lastIndexOf(" | ");
        if (pipeIndex != -1 && pipeIndex < strippedTitle.length() - 3) {
            String extracted = strippedTitle.substring(pipeIndex + 3).trim();
            String[] parts = extracted.split("[^a-zA-Z0-9_]");
            return parts.length > 0 ? parts[0] : null;
        }
        int dashIndex = strippedTitle.lastIndexOf(" - ");
        if (dashIndex != -1 && dashIndex < strippedTitle.length() - 3) {
            String extracted = strippedTitle.substring(dashIndex + 3).trim();
            String[] parts = extracted.split("[^a-zA-Z0-9_]");
            return parts.length > 0 ? parts[0] : null;
        }
        return null;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player;
        MenuHandler activeMenu;
        HumanEntity humanEntity = event.getPlayer();
        if (humanEntity instanceof Player && (activeMenu = this.activeMenus.remove(player = (Player)humanEntity)) != null) {
            activeMenu.cleanupPlayer(player);
        }
    }

    public void setActiveMenu(Player player, MenuHandler menu) {
        this.activeMenus.put(player, menu);
    }

    public void cleanupPlayer(Player player) {
        MenuHandler activeMenu = this.activeMenus.remove(player);
        if (activeMenu != null) {
            activeMenu.cleanupPlayer(player);
        }
    }

    public MainMenu getMainMenu() {
        return this.mainMenu;
    }

    public BanMenu getBanMenu() {
        return this.banMenu;
    }

    public TempbanMenu getTempbanMenu() {
        return this.tempbanMenu;
    }

    public MuteMenu getMuteMenu() {
        return this.muteMenu;
    }

    public TempmuteMenu getTempmuteMenu() {
        return this.tempmuteMenu;
    }

    public KickMenu getKickMenu() {
        return this.kickMenu;
    }

    public WarnMenu getWarnMenu() {
        return this.warnMenu;
    }

    public NotesMenu getNotesMenu() {
        return this.notesMenu;
    }

    public UnbanMenu getUnbanMenu() {
        return this.unbanMenu;
    }

    public UnmuteMenu getUnmuteMenu() {
        return this.unmuteMenu;
    }
}

