/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.models;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.UUID;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;

public class PlayerData {
    private UUID uuid;
    private String name;
    private String ipAddress;
    private LocalDateTime firstJoin;
    private LocalDateTime lastSeen;
    private long firstJoinTimestamp;
    private long lastJoinTimestamp;
    private String lastIP;
    private boolean banned;
    private boolean muted;
    private boolean warned;
    private boolean noted;
    private boolean kicked;
    private Punishment activeBan;
    private Punishment activeMute;

    public PlayerData() {
    }

    public PlayerData(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
        this.firstJoin = LocalDateTime.now();
        this.lastSeen = LocalDateTime.now();
        this.firstJoinTimestamp = System.currentTimeMillis();
        this.lastJoinTimestamp = System.currentTimeMillis();
        this.banned = false;
        this.muted = false;
        this.warned = false;
        this.noted = false;
        this.kicked = false;
    }

    public PlayerData(UUID uuid, String name, String ipAddress) {
        this.uuid = uuid;
        this.name = name;
        this.ipAddress = ipAddress;
        this.firstJoin = LocalDateTime.now();
        this.lastSeen = LocalDateTime.now();
        this.firstJoinTimestamp = System.currentTimeMillis();
        this.lastJoinTimestamp = System.currentTimeMillis();
        this.lastIP = ipAddress;
        this.banned = false;
        this.muted = false;
        this.warned = false;
        this.noted = false;
        this.kicked = false;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPlayerName() {
        return this.name;
    }

    public void setPlayerName(String playerName) {
        this.name = playerName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public LocalDateTime getFirstJoin() {
        return this.firstJoin;
    }

    public void setFirstJoin(LocalDateTime firstJoin) {
        this.firstJoin = firstJoin;
    }

    public void setFirstJoin(long firstJoinTimestamp) {
        this.firstJoinTimestamp = firstJoinTimestamp;
        this.firstJoin = new Timestamp(firstJoinTimestamp).toLocalDateTime();
    }

    public LocalDateTime getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(LocalDateTime lastSeen) {
        this.lastSeen = lastSeen;
    }

    public long getFirstJoinTimestamp() {
        return this.firstJoinTimestamp;
    }

    public long getLastJoinTimestamp() {
        return this.lastJoinTimestamp;
    }

    public LocalDateTime getLastJoin() {
        return new Timestamp(this.lastJoinTimestamp).toLocalDateTime();
    }

    public void setLastJoin(long lastJoinTimestamp) {
        this.lastJoinTimestamp = lastJoinTimestamp;
    }

    public String getLastIP() {
        return this.lastIP;
    }

    public void setLastIP(String lastIP) {
        this.lastIP = lastIP;
    }

    public boolean isBanned() {
        return this.banned;
    }

    public void setBanned(boolean banned) {
        this.banned = banned;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
    }

    public boolean isWarned() {
        return this.warned;
    }

    public void setWarned(boolean warned) {
        this.warned = warned;
    }

    public boolean isNoted() {
        return this.noted;
    }

    public void setNoted(boolean noted) {
        this.noted = noted;
    }

    public boolean isKicked() {
        return this.kicked;
    }

    public void setKicked(boolean kicked) {
        this.kicked = kicked;
    }

    public Punishment getActiveBan() {
        return this.activeBan;
    }

    public void setActiveBan(Punishment activeBan) {
        this.activeBan = activeBan;
        this.banned = activeBan != null && activeBan.isActive() && !activeBan.isExpired();
    }

    public Punishment getActiveMute() {
        return this.activeMute;
    }

    public void setActiveMute(Punishment activeMute) {
        this.activeMute = activeMute;
        this.muted = activeMute != null && activeMute.isActive() && !activeMute.isExpired();
    }

    public void updateLastSeen() {
        this.lastSeen = LocalDateTime.now();
        this.lastJoinTimestamp = System.currentTimeMillis();
    }

    public boolean hasActivePunishment(PunishmentType type) {
        switch (type) {
            case BAN: 
            case TEMPBAN: {
                return this.banned && this.activeBan != null && this.activeBan.isActive() && !this.activeBan.isExpired();
            }
            case MUTE: 
            case TEMPMUTE: {
                return this.muted && this.activeMute != null && this.activeMute.isActive() && !this.activeMute.isExpired();
            }
            case WARN: {
                return this.warned;
            }
            case NOTE: {
                return this.noted;
            }
            case KICK: {
                return this.kicked;
            }
        }
        return false;
    }

    public void setIpBanned(boolean ipBanned) {
        this.banned = ipBanned;
    }

    public void setIpMuted(boolean ipMuted) {
        this.muted = ipMuted;
    }

    public void setIpWarned(boolean ipWarned) {
        this.warned = ipWarned;
    }

    public void setIpKicked(boolean ipKicked) {
        this.kicked = ipKicked;
    }
}

