/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.models;

import java.util.List;
import java.util.Map;
import me.wethink.weGuardian.models.PunishmentType;

public class PunishmentTemplate {
    private String name;
    private String category;
    private List<EscalationLevel> escalationLevels;
    private boolean enabled;
    private Map<String, String> variables;

    public PunishmentTemplate(String name, String category, List<EscalationLevel> escalationLevels) {
        this.name = name;
        this.category = category;
        this.escalationLevels = escalationLevels;
        this.enabled = true;
    }

    public EscalationLevel getEscalationLevel(int currentOffenses) {
        if (this.escalationLevels.isEmpty()) {
            return null;
        }
        EscalationLevel selectedLevel = this.escalationLevels.get(0);
        for (EscalationLevel level : this.escalationLevels) {
            if (currentOffenses < level.getLevel()) break;
            selectedLevel = level;
        }
        return selectedLevel;
    }

    public String processReason(String baseReason, Map<String, String> placeholders) {
        String processedReason = baseReason;
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                processedReason = processedReason.replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return processedReason;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public List<EscalationLevel> getEscalationLevels() {
        return this.escalationLevels;
    }

    public void setEscalationLevels(List<EscalationLevel> escalationLevels) {
        this.escalationLevels = escalationLevels;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public static class EscalationLevel {
        private int level;
        private PunishmentType type;
        private String duration;
        private String reason;
        private boolean permanent;

        public EscalationLevel(int level, PunishmentType type, String duration, String reason) {
            this.level = level;
            this.type = type;
            this.duration = duration;
            this.reason = reason;
            this.permanent = duration == null || duration.equalsIgnoreCase("permanent");
        }

        public int getLevel() {
            return this.level;
        }

        public PunishmentType getType() {
            return this.type;
        }

        public String getDuration() {
            return this.duration;
        }

        public String getReason() {
            return this.reason;
        }

        public boolean isPermanent() {
            return this.permanent;
        }
    }
}

