/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.services;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class ConsoleCommandService {
    private final WeGuardian plugin;

    public ConsoleCommandService(WeGuardian plugin) {
        this.plugin = plugin;
    }

    public void executeConsoleCommands(Punishment punishment) {
        if (!this.plugin.getConfig().getBoolean("console_commands.enabled", false)) {
            this.plugin.debug("Console commands skipped: disabled in config");
            return;
        }
        this.plugin.debug("Executing console commands for punishment: type=%s, target=%s", new Object[]{punishment.getType(), punishment.getTargetName()});
        CompletableFuture.runAsync(() -> {
            String eventKey = this.getEventKey(punishment.getType());
            if (eventKey == null) {
                this.plugin.debug("No console commands configured for punishment type: %s", new Object[]{punishment.getType()});
                return;
            }
            this.plugin.debug("Looking for console commands with event key: %s", eventKey);
            ConfigurationSection commandsSection = this.plugin.getConfig().getConfigurationSection("console_commands." + eventKey);
            if (commandsSection == null) {
                List commands = this.plugin.getConfig().getStringList("console_commands." + eventKey);
                if (commands != null && !commands.isEmpty()) {
                    this.plugin.debug("Found %d console commands to execute", commands.size());
                    this.executeCommands(commands, punishment);
                } else {
                    this.plugin.debug("No console commands found for event key: %s", eventKey);
                }
                return;
            }
            List commands = this.plugin.getConfig().getStringList("console_commands." + eventKey);
            if (commands != null && !commands.isEmpty()) {
                this.plugin.debug("Found %d console commands to execute (fallback)", commands.size());
                this.executeCommands(commands, punishment);
            } else {
                this.plugin.debug("No console commands found for event key: %s (fallback)", eventKey);
            }
        });
    }

    public void executeUnpunishmentCommands(Punishment punishment, String staffName) {
        if (!this.plugin.getConfig().getBoolean("console_commands.enabled", false)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            String eventKey = this.getUnpunishmentEventKey(punishment.getType());
            if (eventKey == null) {
                return;
            }
            List commands = this.plugin.getConfig().getStringList("console_commands." + eventKey);
            if (commands != null && !commands.isEmpty()) {
                this.executeUnpunishmentCommands(commands, punishment, staffName);
            }
        });
    }

    private void executeCommands(List<String> commands, Punishment punishment) {
        this.plugin.debug("Executing %d console commands", commands.size());
        for (String command : commands) {
            String processedCommand = this.processPlaceholders(command, punishment);
            this.plugin.debug("Processed command: %s", processedCommand);
            this.plugin.getFoliaLib().getScheduler().runNextTick(task -> {
                try {
                    this.plugin.debug("Dispatching console command: %s", processedCommand);
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)processedCommand);
                    this.plugin.debug("Console command executed successfully: %s", processedCommand);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to execute console command: " + processedCommand + " - " + e.getMessage());
                    this.plugin.debug("Console command execution failed: %s - %s", processedCommand, e.getMessage());
                }
            });
        }
    }

    private void executeUnpunishmentCommands(List<String> commands, Punishment punishment, String staffName) {
        for (String command : commands) {
            String processedCommand = this.processUnpunishmentPlaceholders(command, punishment, staffName);
            this.plugin.getFoliaLib().getScheduler().runNextTick(task -> {
                try {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)processedCommand);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to execute console command: " + processedCommand + " - " + e.getMessage());
                }
            });
        }
    }

    public void executeCommand(String command) {
        this.plugin.getFoliaLib().getScheduler().runNextTick(task -> {
            try {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to execute console command: " + command + " - " + e.getMessage());
            }
        });
    }

    private String processPlaceholders(String command, Punishment punishment) {
        String processed = command;
        processed = processed.replace("{player}", punishment.getTargetName() != null ? punishment.getTargetName() : "Unknown");
        processed = processed.replace("{staff}", punishment.getStaffName() != null ? punishment.getStaffName() : "Console");
        processed = processed.replace("{reason}", punishment.getReason() != null ? punishment.getReason() : "No reason");
        processed = processed.replace("{type}", punishment.getType().name().toLowerCase());
        processed = processed.replace("{server}", punishment.getServerName() != null ? punishment.getServerName() : "Unknown");
        if (punishment.getExpiresAt() != null) {
            processed = processed.replace("{duration}", MessageUtils.formatPunishmentMessage("{duration}", punishment));
            processed = processed.replace("{expires}", MessageUtils.formatPunishmentMessage("{expires}", punishment));
        } else {
            processed = processed.replace("{duration}", "Permanent");
            processed = processed.replace("{expires}", "Never");
        }
        return MessageUtils.colorize(processed);
    }

    private String processUnpunishmentPlaceholders(String command, Punishment punishment, String staffName) {
        String processed = command;
        processed = processed.replace("{player}", punishment.getTargetName() != null ? punishment.getTargetName() : "Unknown");
        processed = processed.replace("{staff}", staffName != null ? staffName : "Console");
        processed = processed.replace("{original_staff}", punishment.getStaffName() != null ? punishment.getStaffName() : "Console");
        processed = processed.replace("{original_reason}", punishment.getReason() != null ? punishment.getReason() : "No reason");
        processed = processed.replace("{type}", punishment.getType().name().toLowerCase());
        processed = processed.replace("{server}", punishment.getServerName() != null ? punishment.getServerName() : "Unknown");
        return MessageUtils.colorize(processed);
    }

    private String getEventKey(PunishmentType type) {
        return switch (type) {
            case PunishmentType.BAN, PunishmentType.IPBAN -> "on_ban";
            case PunishmentType.TEMPBAN -> "on_tempban";
            case PunishmentType.MUTE, PunishmentType.IPMUTE -> "on_mute";
            case PunishmentType.TEMPMUTE -> "on_tempmute";
            case PunishmentType.KICK, PunishmentType.IPKICK -> "on_kick";
            case PunishmentType.WARN, PunishmentType.IPWARN -> "on_warn";
            default -> null;
        };
    }

    private String getUnpunishmentEventKey(PunishmentType type) {
        return switch (type) {
            case PunishmentType.BAN, PunishmentType.IPBAN, PunishmentType.TEMPBAN -> "on_unban";
            case PunishmentType.MUTE, PunishmentType.IPMUTE, PunishmentType.TEMPMUTE -> "on_unmute";
            default -> null;
        };
    }
}

