/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.web.SessionManager;

public class LogoutApiServlet
extends HttpServlet {
    private final WeGuardian plugin;
    private final SessionManager sessionManager;

    public LogoutApiServlet(WeGuardian plugin, SessionManager sessionManager) {
        this.plugin = plugin;
        this.sessionManager = sessionManager;
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sessionId = this.getSessionIdFromCookies(request);
        if (sessionId != null) {
            this.sessionManager.invalidateSession(sessionId);
        }
        Cookie sessionCookie = new Cookie("sessionId", "");
        sessionCookie.setHttpOnly(true);
        sessionCookie.setMaxAge(0);
        sessionCookie.setPath("/");
        response.addCookie(sessionCookie);
        response.sendRedirect("/login");
    }

    private String getSessionIdFromCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"sessionId".equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

