/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.web;

import java.io.File;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.web.DashboardServlet;
import me.wethink.weGuardian.web.LoginApiServlet;
import me.wethink.weGuardian.web.LoginServlet;
import me.wethink.weGuardian.web.LogoutApiServlet;
import me.wethink.weGuardian.web.PlayersApiServlet;
import me.wethink.weGuardian.web.PlayersServlet;
import me.wethink.weGuardian.web.PunishmentsApiServlet;
import me.wethink.weGuardian.web.PunishmentsServlet;
import me.wethink.weGuardian.web.RecentActivityApiServlet;
import me.wethink.weGuardian.web.RootRedirectServlet;
import me.wethink.weGuardian.web.SessionManager;
import me.wethink.weGuardian.web.SettingsServlet;
import me.wethink.weGuardian.web.StatsApiServlet;
import me.wethink.weGuardian.web.WebSocketEndpoint;
import me.wethink.weGuardian.web.WebSocketHandler;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.websocket.server.WsSci;

public class WebDashboardService {
    private final WeGuardian plugin;
    private Tomcat tomcat;
    private SessionManager sessionManager;
    private WebSocketHandler webSocketHandler;
    private ScheduledExecutorService scheduler;

    public WebDashboardService(WeGuardian plugin) {
        this.plugin = plugin;
        this.sessionManager = new SessionManager(plugin);
        this.webSocketHandler = new WebSocketHandler(plugin, this.sessionManager);
        this.scheduler = Executors.newScheduledThreadPool(2);
        WebSocketEndpoint.setPlugin(plugin);
        WebSocketEndpoint.setWebDashboardService(this);
    }

    public void start() {
        if (!this.plugin.getConfig().getBoolean("web-dashboard.enabled", false)) {
            this.plugin.getLogger().info("Web dashboard is disabled in config");
            return;
        }
        try {
            String host = this.plugin.getConfig().getString("web-dashboard.host", "0.0.0.0");
            int preferredPort = this.plugin.getConfig().getInt("web-dashboard.port", 8080);
            boolean autoDetectPort = this.plugin.getConfig().getBoolean("web-dashboard.auto-detect-port", true);
            String bindHost = WebDashboardService.sanitizeBindHost(host);
            if (!bindHost.equals(host)) {
                this.plugin.getLogger().warning("Configured host '" + host + "' is not bindable. Falling back to '" + bindHost + "'.");
            }
            int port = preferredPort;
            if (autoDetectPort) {
                int detected = WebDashboardService.findAvailablePort(bindHost, preferredPort);
                if (detected != preferredPort) {
                    this.plugin.getLogger().info("Port " + preferredPort + " is unavailable. Selected free port " + detected);
                }
                port = detected;
            }
            this.tomcat = new Tomcat();
            this.tomcat.setBaseDir(WebDashboardService.createTempDir().getAbsolutePath());
            Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
            connector.setPort(port);
            connector.setProperty("address", bindHost);
            this.tomcat.setConnector(connector);
            File docBase = new File("src/main/resources/web");
            if (!docBase.exists()) {
                docBase.mkdirs();
            }
            Context context = this.tomcat.addContext("", docBase.getAbsolutePath());
            context.addServletContainerInitializer(new WsSci(), null);
            Tomcat.addServlet(context, "RootRedirectServlet", new RootRedirectServlet());
            context.addServletMappingDecoded("/", "RootRedirectServlet");
            Tomcat.addServlet(context, "LoginServlet", new LoginServlet(this.plugin, this.sessionManager));
            context.addServletMappingDecoded("/login", "LoginServlet");
            Tomcat.addServlet(context, "DashboardServlet", new DashboardServlet(this.plugin, this.sessionManager));
            context.addServletMappingDecoded("/dashboard", "DashboardServlet");
            Tomcat.addServlet(context, "PunishmentsServlet", new PunishmentsServlet(this.plugin, this.sessionManager));
            context.addServletMappingDecoded("/punishments", "PunishmentsServlet");
            Tomcat.addServlet(context, "PlayersServlet", new PlayersServlet(this.plugin, this.sessionManager));
            context.addServletMappingDecoded("/players", "PlayersServlet");
            Tomcat.addServlet(context, "SettingsServlet", new SettingsServlet(this.plugin, this.sessionManager));
            context.addServletMappingDecoded("/settings", "SettingsServlet");
            Tomcat.addServlet(context, "LoginApiServlet", new LoginApiServlet(this.plugin, this.sessionManager));
            context.addServletMappingDecoded("/api/login", "LoginApiServlet");
            Tomcat.addServlet(context, "LogoutApiServlet", new LogoutApiServlet(this.plugin, this.sessionManager));
            context.addServletMappingDecoded("/api/logout", "LogoutApiServlet");
            Tomcat.addServlet(context, "PunishmentsApiServlet", new PunishmentsApiServlet(this.plugin, this.sessionManager));
            context.addServletMappingDecoded("/api/punishments/*", "PunishmentsApiServlet");
            Tomcat.addServlet(context, "PlayersApiServlet", new PlayersApiServlet(this.plugin, this.sessionManager));
            context.addServletMappingDecoded("/api/players/*", "PlayersApiServlet");
            Tomcat.addServlet(context, "StatsApiServlet", new StatsApiServlet(this.plugin, this.sessionManager));
            context.addServletMappingDecoded("/api/stats", "StatsApiServlet");
            Tomcat.addServlet(context, "RecentActivityApiServlet", new RecentActivityApiServlet(this.plugin, this.sessionManager));
            context.addServletMappingDecoded("/api/recent-activity", "RecentActivityApiServlet");
            try {
                this.tomcat.start();
            }
            catch (Exception e) {
                Throwable cause;
                boolean isBindException = false;
                for (cause = e; cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof BindException)) continue;
                    isBindException = true;
                    break;
                }
                if (isBindException) {
                    if (!autoDetectPort) {
                        throw e;
                    }
                    int fallbackPort = WebDashboardService.findAvailablePort(bindHost, 0);
                    this.plugin.getLogger().warning("Failed to bind to port " + port + ": " + (cause != null ? cause.getMessage() : "Unknown error") + ". Retrying on free port " + fallbackPort);
                    connector.setPort(fallbackPort);
                    this.tomcat.start();
                    port = fallbackPort;
                }
                throw e;
            }
            int actualPort = connector.getLocalPort() > 0 ? connector.getLocalPort() : port;
            this.plugin.getLogger().info("Web dashboard started on http://" + bindHost + ":" + actualPort);
            this.startScheduledTasks();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to start web dashboard: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.tomcat != null) {
            try {
                this.tomcat.stop();
                this.plugin.getLogger().info("Web dashboard stopped");
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error stopping web dashboard: " + e.getMessage());
            }
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    private void startScheduledTasks() {
        this.scheduler.scheduleAtFixedRate(() -> this.sessionManager.cleanupExpiredSessions(), 5L, 5L, TimeUnit.MINUTES);
        this.scheduler.scheduleAtFixedRate(() -> this.webSocketHandler.broadcastStats(), 30L, 30L, TimeUnit.SECONDS);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public WebSocketHandler getWebSocketHandler() {
        return this.webSocketHandler;
    }

    private static String sanitizeBindHost(String configuredHost) {
        String string;
        String host = configuredHost == null || configuredHost.isBlank() ? "0.0.0.0" : configuredHost.trim();
        ServerSocket ss = new ServerSocket(0, 1, InetAddress.getByName(host));
        try {
            string = host;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ignored) {
                return "0.0.0.0";
            }
        }
        ss.close();
        return string;
    }

    private static boolean isPortFree(String host, int port) {
        boolean bl;
        ServerSocket ss = new ServerSocket(port, 1, InetAddress.getByName(host));
        try {
            ss.setReuseAddress(true);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        ss.close();
        return bl;
    }

    private static int findAvailablePort(String host, int preferredPort) {
        int n;
        if (preferredPort > 0 && WebDashboardService.isPortFree(host, preferredPort)) {
            return preferredPort;
        }
        ServerSocket ss = new ServerSocket(0, 50, InetAddress.getByName(host));
        try {
            ss.setReuseAddress(true);
            n = ss.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                int n2;
                ServerSocket ss2 = new ServerSocket(0, 50, InetAddress.getByName("0.0.0.0"));
                try {
                    ss2.setReuseAddress(true);
                    n2 = ss2.getLocalPort();
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            ss2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    catch (Exception ex) {
                        return preferredPort > 0 ? preferredPort : 8080;
                    }
                }
                ss2.close();
                return n2;
            }
        }
        ss.close();
        return n;
    }

    private static File createTempDir() {
        try {
            File temp = File.createTempFile("tomcat.", ".dir");
            if (!temp.delete()) {
                throw new RuntimeException();
            }
            if (!temp.mkdir()) {
                throw new RuntimeException();
            }
            temp.deleteOnExit();
            return temp;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create temp dir for Tomcat", e);
        }
    }
}

