/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.web;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import jakarta.websocket.Session;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.web.SessionManager;

public class WebSocketHandler {
    private final WeGuardian plugin;
    private final SessionManager sessionManager;
    private final Set<Session> connections = ConcurrentHashMap.newKeySet();
    private final Gson gson = new Gson();

    public WebSocketHandler(WeGuardian plugin, SessionManager sessionManager) {
        this.plugin = plugin;
        this.sessionManager = sessionManager;
    }

    public void addConnection(Session session) {
        this.connections.add(session);
        this.plugin.getLogger().info("WebSocket connection added. Total connections: " + this.connections.size());
    }

    public void removeConnection(Session session) {
        this.connections.remove(session);
        this.plugin.getLogger().info("WebSocket connection removed. Total connections: " + this.connections.size());
    }

    public void broadcastPunishmentUpdate(Punishment punishment, String action) {
        JsonObject message = new JsonObject();
        message.addProperty("type", "punishment_update");
        message.addProperty("action", action);
        message.add("punishment", this.gson.toJsonTree(punishment));
        this.broadcast(message.toString());
    }

    public void broadcastStats() {
        CompletableFuture.runAsync(() -> {
            try {
                JsonObject stats = new JsonObject();
                stats.addProperty("type", "stats_update");
                List<Punishment> activePunishments = this.plugin.getDatabaseManager().getActivePunishments(null).join();
                int activeBans = (int)activePunishments.stream().filter(p -> p.getType().toString().contains("BAN")).count();
                int activeMutes = (int)activePunishments.stream().filter(p -> p.getType().toString().contains("MUTE")).count();
                stats.addProperty("active_bans", activeBans);
                stats.addProperty("active_mutes", activeMutes);
                stats.addProperty("total_punishments", activePunishments.size());
                this.broadcast(stats.toString());
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error broadcasting stats: " + e.getMessage());
            }
        });
    }

    public void broadcast(String message) {
        this.connections.removeIf(session -> {
            try {
                if (session.isOpen()) {
                    session.getBasicRemote().sendText(message);
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error sending WebSocket message: " + e.getMessage());
                return true;
            }
        });
    }
}

