/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class StatsCommand
implements CommandExecutor,
TabCompleter {
    private final WeGuardian plugin;

    public StatsCommand(WeGuardian plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("weguardian.stats")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        this.plugin.getDatabaseManager().getAllPunishments().thenAccept(punishments -> {
            if (punishments.isEmpty()) {
                sender.sendMessage(MessageUtils.colorize("&eNo punishments found in the database."));
                return;
            }
            HashMap<PunishmentType, Integer> totalStats = new HashMap<PunishmentType, Integer>();
            HashMap<PunishmentType, Integer> activeStats = new HashMap<PunishmentType, Integer>();
            for (PunishmentType type : PunishmentType.values()) {
                totalStats.put(type, 0);
                activeStats.put(type, 0);
            }
            for (Punishment punishment : punishments) {
                PunishmentType type = punishment.getType();
                totalStats.put(type, (Integer)totalStats.get((Object)type) + 1);
                if (!punishment.isActive()) continue;
                activeStats.put(type, (Integer)activeStats.get((Object)type) + 1);
            }
            int totalPunishments = punishments.size();
            int activePunishments = punishments.stream().mapToInt(p -> p.isActive() ? 1 : 0).sum();
            sender.sendMessage(MessageUtils.colorize("&6&l=== WeGuardian Global Statistics ==="));
            sender.sendMessage(MessageUtils.colorize("&7Total punishments: &f" + totalPunishments));
            sender.sendMessage(MessageUtils.colorize("&7Active punishments: &a" + activePunishments));
            sender.sendMessage(MessageUtils.colorize("&7Expired/removed: &7" + (totalPunishments - activePunishments)));
            sender.sendMessage("");
            sender.sendMessage(MessageUtils.colorize("&6Total Punishment Breakdown:"));
            sender.sendMessage(MessageUtils.colorize("&7  Bans: &f" + String.valueOf(totalStats.get((Object)PunishmentType.BAN)) + " &8(Active: &a" + String.valueOf(activeStats.get((Object)PunishmentType.BAN)) + "&8)"));
            sender.sendMessage(MessageUtils.colorize("&7  Tempbans: &f" + String.valueOf(totalStats.get((Object)PunishmentType.TEMPBAN)) + " &8(Active: &a" + String.valueOf(activeStats.get((Object)PunishmentType.TEMPBAN)) + "&8)"));
            sender.sendMessage(MessageUtils.colorize("&7  Mutes: &f" + String.valueOf(totalStats.get((Object)PunishmentType.MUTE)) + " &8(Active: &a" + String.valueOf(activeStats.get((Object)PunishmentType.MUTE)) + "&8)"));
            sender.sendMessage(MessageUtils.colorize("&7  Tempmutes: &f" + String.valueOf(totalStats.get((Object)PunishmentType.TEMPMUTE)) + " &8(Active: &a" + String.valueOf(activeStats.get((Object)PunishmentType.TEMPMUTE)) + "&8)"));
            sender.sendMessage(MessageUtils.colorize("&7  Kicks: &f" + String.valueOf(totalStats.get((Object)PunishmentType.KICK))));
            sender.sendMessage(MessageUtils.colorize("&7  Warns: &f" + String.valueOf(totalStats.get((Object)PunishmentType.WARN))));
            sender.sendMessage(MessageUtils.colorize("&7  Notes: &f" + String.valueOf(totalStats.get((Object)PunishmentType.NOTE))));
            sender.sendMessage("");
            long uniquePlayersCount = punishments.stream().map(Punishment::getTargetUuid).distinct().count();
            long uniqueStaffCount = punishments.stream().map(Punishment::getStaffUuid).distinct().count();
            sender.sendMessage(MessageUtils.colorize("&7Unique punished players: &f" + uniquePlayersCount));
            sender.sendMessage(MessageUtils.colorize("&7Active staff members: &f" + uniqueStaffCount));
        });
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        return new ArrayList<String>();
    }
}

