/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.gui.menus;

import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.gui.MenuHandler;
import me.wethink.weGuardian.gui.menus.MenuManager;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class MuteMenu
extends MenuHandler {
    private final MenuManager menuManager;

    public MuteMenu(WeGuardian plugin, MenuManager menuManager) {
        super(plugin, "mute");
        this.menuManager = menuManager;
    }

    @Override
    protected ConfigurationSection getMenuConfig() {
        return this.plugin.getGUIConfigLoader().getGUIConfig("mute");
    }

    @Override
    protected void handleItemClick(Player staff, String targetPlayer, String itemKey, ConfigurationSection itemConfig) {
        String reason;
        String menuType;
        String[] parts;
        String action = itemConfig.getString("action", "");
        this.plugin.getLogger().info("MuteMenu: Player " + staff.getName() + " clicked item " + itemKey + " with action: " + action);
        if (action.startsWith("execute_punishment:") && (parts = action.split(":", 3)).length >= 3) {
            String punishmentType = parts[1];
            String reason2 = parts[2];
            this.executeMute(staff, targetPlayer, reason2);
            return;
        }
        if (action.startsWith("open_menu:") && (menuType = action.substring("open_menu:".length())).equals("main")) {
            this.menuManager.setActiveMenu(staff, this.menuManager.getMainMenu());
            this.menuManager.getMainMenu().openMenu(staff, targetPlayer);
            return;
        }
        if (action.equals("back") || itemKey.equals("back")) {
            this.menuManager.setActiveMenu(staff, this.menuManager.getMainMenu());
            this.menuManager.getMainMenu().openMenu(staff, targetPlayer);
            return;
        }
        if (action.equals("close") || itemKey.equals("close")) {
            staff.closeInventory();
            return;
        }
        if (action.startsWith("custom_reason:")) {
            staff.sendMessage(MessageUtils.colorize("&eCustom input feature coming in next update!"));
            staff.sendMessage(MessageUtils.colorize("&7For now, please use the predefined options."));
            return;
        }
        if (itemConfig.contains("reason")) {
            reason = itemConfig.getString("reason", "No reason specified");
            this.executeMute(staff, targetPlayer, reason);
            return;
        }
        reason = itemConfig.getString("reason", "No reason specified");
        this.executeMute(staff, targetPlayer, reason);
    }

    private void executeMute(Player staff, String targetPlayer, String reason) {
        staff.closeInventory();
        this.clearSelectedData(staff);
        staff.sendMessage(MessageUtils.colorize("&eExecuting mute on &a" + targetPlayer + " &efor: &f" + reason));
        ((CompletableFuture)this.plugin.getPunishmentService().mute(targetPlayer, staff.getName(), reason).thenAccept(success -> {
            if (success.booleanValue()) {
                staff.sendMessage(MessageUtils.colorize("&aSuccessfully muted " + targetPlayer + " for: &e" + reason));
            } else {
                staff.sendMessage(MessageUtils.colorize("&cFailed to mute " + targetPlayer + ". Player may already be muted."));
            }
        })).exceptionally(throwable -> {
            this.plugin.getLogger().severe("Error executing mute: " + throwable.getMessage());
            staff.sendMessage(MessageUtils.colorize("&cAn error occurred while executing the mute."));
            return null;
        });
    }

    @Override
    protected void onMenuOpen(Player staff, String targetPlayer) {
        this.plugin.debug("Staff %s opened mute menu for %s", staff.getName(), targetPlayer);
    }
}

