/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.gui.menus;

import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.gui.MenuHandler;
import me.wethink.weGuardian.gui.menus.MenuManager;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class UnbanMenu
extends MenuHandler {
    private final MenuManager menuManager;

    public UnbanMenu(WeGuardian plugin, MenuManager menuManager) {
        super(plugin, "unban");
        this.menuManager = menuManager;
    }

    protected MenuManager getMenuManager() {
        return this.menuManager;
    }

    @Override
    protected ConfigurationSection getMenuConfig() {
        return this.plugin.getGUIConfigLoader().getGUIConfig("unban");
    }

    @Override
    protected void handleItemClick(Player staff, String targetPlayer, String itemKey, ConfigurationSection itemConfig) {
        String[] parts;
        String action = itemConfig.getString("action", "");
        if (action.startsWith("execute_punishment:") && (parts = action.split(":", 3)).length >= 2) {
            this.executeUnban(staff, targetPlayer);
            return;
        }
        if (action.equals("back") || itemKey.equals("back")) {
            this.getMenuManager().setActiveMenu(staff, this.getMenuManager().getMainMenu());
            this.getMenuManager().getMainMenu().openMenu(staff, targetPlayer);
            return;
        }
        if (action.equals("close") || itemKey.equals("close")) {
            staff.closeInventory();
            return;
        }
        if (action.equals("confirm") || itemKey.equals("confirm") || itemKey.equals("unban")) {
            this.executeUnban(staff, targetPlayer);
            return;
        }
        this.executeUnban(staff, targetPlayer);
    }

    private void executeUnban(Player staff, String targetPlayer) {
        staff.closeInventory();
        this.clearSelectedData(staff);
        staff.sendMessage(MessageUtils.colorize("&eExecuting unban on &a" + targetPlayer));
        ((CompletableFuture)this.plugin.getPunishmentService().unban(targetPlayer, staff.getName()).thenAccept(success -> {
            if (success.booleanValue()) {
                staff.sendMessage(MessageUtils.colorize("&aSuccessfully unbanned " + targetPlayer));
            } else {
                staff.sendMessage(MessageUtils.colorize("&cFailed to unban " + targetPlayer + ". Player may not be banned."));
            }
        })).exceptionally(throwable -> {
            this.plugin.getLogger().severe("Error executing unban: " + throwable.getMessage());
            staff.sendMessage(MessageUtils.colorize("&cAn error occurred while executing the unban."));
            return null;
        });
    }

    @Override
    protected void onMenuOpen(Player staff, String targetPlayer) {
        if (this.plugin.getConfig().getBoolean("debug.enabled", false)) {
            this.plugin.debug("Staff %s opened unban menu for %s", staff.getName(), targetPlayer);
        }
    }
}

