/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.services;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.database.DatabaseManager;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentTemplate;
import me.wethink.weGuardian.models.PunishmentType;
import me.wethink.weGuardian.services.PunishmentService;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class TemplateService {
    private final WeGuardian plugin;
    private final DatabaseManager database;
    private final Map<String, PunishmentTemplate> templates;
    private FileConfiguration templatesConfig;

    public TemplateService(WeGuardian plugin) {
        this.plugin = plugin;
        this.database = plugin.getDatabaseManager();
        this.templates = new ConcurrentHashMap<String, PunishmentTemplate>();
        this.loadTemplates();
    }

    private void loadTemplates() {
        File templatesFile = new File(this.plugin.getDataFolder(), "templates.yml");
        if (!templatesFile.exists()) {
            this.plugin.saveResource("templates.yml", false);
        }
        this.templatesConfig = YamlConfiguration.loadConfiguration((File)templatesFile);
        this.templates.clear();
        ConfigurationSection templatesSection = this.templatesConfig.getConfigurationSection("templates");
        if (templatesSection != null) {
            for (String templateName : templatesSection.getKeys(false)) {
                ConfigurationSection templateSection = templatesSection.getConfigurationSection(templateName);
                if (templateSection == null) continue;
                this.loadTemplate(templateName, templateSection);
            }
        }
        this.plugin.debug("Loaded " + this.templates.size() + " punishment templates");
    }

    private void loadTemplate(String name, ConfigurationSection section) {
        try {
            String category = section.getString("category", "general");
            boolean enabled = section.getBoolean("enabled", true);
            ArrayList<PunishmentTemplate.EscalationLevel> levels = new ArrayList<PunishmentTemplate.EscalationLevel>();
            ConfigurationSection levelsSection = section.getConfigurationSection("escalation");
            if (levelsSection != null) {
                for (String levelKey : levelsSection.getKeys(false)) {
                    ConfigurationSection levelSection = levelsSection.getConfigurationSection(levelKey);
                    if (levelSection == null) continue;
                    int level = Integer.parseInt(levelKey);
                    PunishmentType type = PunishmentType.valueOf(levelSection.getString("type", "WARN").toUpperCase());
                    String duration = levelSection.getString("duration");
                    String reason = levelSection.getString("reason", "Violation of server rules");
                    levels.add(new PunishmentTemplate.EscalationLevel(level, type, duration, reason));
                }
            }
            levels.sort(Comparator.comparingInt(PunishmentTemplate.EscalationLevel::getLevel));
            PunishmentTemplate template = new PunishmentTemplate(name, category, levels);
            template.setEnabled(enabled);
            this.templates.put(name, template);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to load template '" + name + "': " + e.getMessage());
        }
    }

    public CompletableFuture<PunishmentTemplate.EscalationLevel> calculatePunishment(UUID playerUuid, String templateName) {
        return CompletableFuture.supplyAsync(() -> {
            PunishmentTemplate template = this.templates.get(templateName);
            if (template == null || !template.isEnabled()) {
                return null;
            }
            try {
                List<Punishment> history = this.database.getPunishmentHistory(playerUuid).join();
                int offenseCount = (int)history.stream().filter(p -> p.getReason().contains(template.getCategory()) || p.getReason().contains(templateName)).count();
                return template.getEscalationLevel(offenseCount + 1);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to calculate punishment for template '" + templateName + "': " + e.getMessage());
                return template.getEscalationLevel(1);
            }
        });
    }

    private int getEscalationLevel(UUID playerUuid, String templateName) {
        try {
            PunishmentTemplate template = this.templates.get(templateName);
            if (template == null) {
                return 1;
            }
            List<Punishment> history = this.database.getPunishmentHistory(playerUuid).join();
            int offenseCount = (int)history.stream().filter(p -> p.getReason().contains(template.getCategory()) || p.getReason().contains(templateName)).count();
            return offenseCount + 1;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get escalation level for template '" + templateName + "': " + e.getMessage());
            return 1;
        }
    }

    public CompletableFuture<Boolean> executePunishmentFromTemplate(UUID playerUuid, String playerName, String staffName, String templateName, Map<String, String> context) {
        return CompletableFuture.supplyAsync(() -> {
            int escalationLevel;
            if (!this.templates.containsKey(templateName)) {
                this.plugin.getLogger().warning("Template '" + templateName + "' not found");
                return false;
            }
            PunishmentTemplate template = this.templates.get(templateName);
            PunishmentTemplate.EscalationLevel level = template.getEscalationLevel(escalationLevel = this.getEscalationLevel(playerUuid, templateName));
            if (level == null) {
                this.plugin.getLogger().warning("No escalation level found for template '" + templateName + "' at level " + escalationLevel);
                return false;
            }
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", playerName);
            placeholders.put("staff", staffName);
            if (context != null) {
                placeholders.putAll(context);
            }
            String processedReason = template.processReason(level.getReason(), placeholders);
            PunishmentService punishmentService = this.plugin.getPunishmentService();
            try {
                return switch (level.getType()) {
                    case PunishmentType.BAN -> punishmentService.ban(playerName, staffName, processedReason).get();
                    case PunishmentType.TEMPBAN -> punishmentService.tempban(playerName, staffName, processedReason, level.getDuration()).get();
                    case PunishmentType.MUTE -> punishmentService.mute(playerName, staffName, processedReason).get();
                    case PunishmentType.TEMPMUTE -> punishmentService.tempmute(playerName, staffName, processedReason, level.getDuration()).get();
                    case PunishmentType.KICK -> punishmentService.kick(playerName, staffName, processedReason).get();
                    case PunishmentType.WARN -> punishmentService.warn(playerName, staffName, processedReason).get();
                    default -> false;
                };
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error executing template punishment: " + e.getMessage());
                return false;
            }
        });
    }

    public CompletableFuture<Boolean> executePunishmentFromTemplate(UUID playerUuid, String playerName, String staffName, String templateName, String reason) {
        HashMap<String, String> context = new HashMap<String, String>();
        if (reason != null) {
            context.put("reason", reason);
        }
        return this.executePunishmentFromTemplate(playerUuid, playerName, staffName, templateName, context);
    }

    public CompletableFuture<Boolean> executeTemplate(CommandSender sender, String targetName, String templateName, String duration) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                UUID targetUuid = this.plugin.getPunishmentService().getPlayerUUID(targetName).join();
                if (targetUuid == null) {
                    sender.sendMessage("\u00a7cPlayer '" + targetName + "' not found.");
                    return false;
                }
                String staffName = sender instanceof Player ? sender.getName() : "Console";
                HashMap<String, String> context = new HashMap<String, String>();
                if (duration != null && !duration.isEmpty()) {
                    context.put("duration", duration);
                }
                return this.executePunishmentFromTemplate(targetUuid, targetName, staffName, templateName, context).join();
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error executing template: " + e.getMessage());
                sender.sendMessage("\u00a7cError executing template: " + e.getMessage());
                return false;
            }
        });
    }

    public PunishmentTemplate getTemplate(String name) {
        return this.templates.get(name);
    }

    public Collection<PunishmentTemplate> getAllTemplates() {
        return this.templates.values();
    }

    public Collection<PunishmentTemplate> getTemplatesByCategory(String category) {
        return this.templates.values().stream().filter(template -> template.getCategory().equalsIgnoreCase(category)).toList();
    }

    public void reloadTemplates() {
        this.loadTemplates();
    }

    public CompletableFuture<Boolean> executeIPTemplate(String targetIP, String staffName, String templateName, Map<String, String> context) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                PunishmentTemplate template = this.getTemplate(templateName);
                if (template == null) {
                    this.plugin.getLogger().warning("Template '" + templateName + "' not found");
                    return false;
                }
                PunishmentTemplate.EscalationLevel escalationLevel = template.getEscalationLevel(1);
                if (escalationLevel == null) {
                    this.plugin.getLogger().warning("No escalation levels found for template '" + templateName + "'");
                    return false;
                }
                return this.plugin.getPunishmentService().ipmute(targetIP, staffName, escalationLevel.getReason()).join();
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error executing IP template: " + e.getMessage());
                return false;
            }
        });
    }

    public boolean hasTemplate(String name) {
        return this.templates.containsKey(name);
    }

    public void shutdown() {
        this.templates.clear();
        this.plugin.getLogger().info("TemplateService shutdown completed");
    }
}

