/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.services.PunishmentService;
import me.wethink.weGuardian.services.TemplateService;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class BanCommand
implements CommandExecutor,
TabCompleter {
    private final WeGuardian plugin;
    private final PunishmentService punishmentService;
    private final TemplateService templateService;

    public BanCommand(WeGuardian plugin, PunishmentService punishmentService) {
        this.plugin = plugin;
        this.punishmentService = punishmentService;
        this.templateService = plugin.getTemplateService();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.plugin.debug("Ban command executed by %s with args: %s", sender.getName(), String.join((CharSequence)" ", args));
        if (!sender.hasPermission("weguardian.ban")) {
            this.plugin.debug("Ban command denied: %s lacks permission", sender.getName());
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        if (args.length < 2) {
            this.plugin.debug("Ban command usage help shown to %s", sender.getName());
            sender.sendMessage(MessageUtils.colorize("&cUsage: /ban <player> <reason> [-s] [-t template] [-d duration]"));
            sender.sendMessage(MessageUtils.colorize("&7Options:"));
            sender.sendMessage(MessageUtils.colorize("&7  -s: Silent ban (no broadcast)"));
            sender.sendMessage(MessageUtils.colorize("&7  -t <template>: Use punishment template"));
            sender.sendMessage(MessageUtils.colorize("&7  -d <duration>: Specify ban duration (e.g., 1h, 1d, 1w, 1m, 1y)"));
            return true;
        }
        String targetName = args[0];
        ArrayList<String> reasonParts = new ArrayList<String>();
        boolean tempSilent = false;
        String tempTemplateName = null;
        String tempDuration = null;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-s")) {
                tempSilent = true;
                continue;
            }
            if (arg.equals("-t") && i + 1 < args.length) {
                tempTemplateName = args[i + 1];
                ++i;
                continue;
            }
            if (arg.equals("-d") && i + 1 < args.length) {
                tempDuration = args[i + 1];
                ++i;
                continue;
            }
            reasonParts.add(arg);
        }
        boolean silent = tempSilent;
        String templateName = tempTemplateName;
        String duration = tempDuration;
        if (reasonParts.isEmpty()) {
            sender.sendMessage(MessageUtils.colorize("&cYou must provide a reason for the ban."));
            return true;
        }
        String reason = String.join((CharSequence)" ", reasonParts);
        ((CompletableFuture)this.punishmentService.getPlayerUUID(targetName).thenCompose(uuid -> {
            if (uuid == null) {
                this.plugin.debug("Ban command failed: player not found - %s", targetName);
                sender.sendMessage(MessageUtils.colorize("&cPlayer '" + targetName + "' not found."));
                return CompletableFuture.completedFuture(false);
            }
            this.plugin.debug("Ban command: found player UUID %s for %s", uuid, targetName);
            return this.plugin.getDatabaseManager().isPlayerBanned((UUID)uuid).thenCompose(isBanned -> {
                if (isBanned.booleanValue()) {
                    this.plugin.debug("Ban command failed: player already banned - %s", targetName);
                    sender.sendMessage(MessageUtils.colorize("&cPlayer " + targetName + " is already banned."));
                    return CompletableFuture.completedFuture(false);
                }
                this.plugin.debug("Ban command: checking if %s can punish %s", sender.getName(), targetName);
                return this.plugin.getPunishmentService().canPunish(sender, (UUID)uuid).thenCompose(canPunish -> {
                    if (!canPunish.booleanValue()) {
                        this.plugin.debug("Ban command failed: %s cannot punish %s", sender.getName(), targetName);
                        sender.sendMessage(MessageUtils.colorize("&cYou cannot punish this player."));
                        return CompletableFuture.completedFuture(false);
                    }
                    if (templateName != null) {
                        HashMap<String, String> context = new HashMap<String, String>();
                        context.put("duration", duration);
                        return this.plugin.getTemplateService().executePunishmentFromTemplate((UUID)uuid, targetName, sender.getName(), templateName, (Map<String, String>)context).thenApply(success -> {
                            if (success.booleanValue()) {
                                if (!silent) {
                                    sender.sendMessage(MessageUtils.colorize("&aSuccessfully banned " + targetName + " using template " + templateName));
                                }
                            } else {
                                sender.sendMessage(MessageUtils.colorize("&cFailed to ban " + targetName + " using template " + templateName));
                            }
                            return success;
                        });
                    }
                    return this.punishmentService.ban(targetName, sender.getName(), reason).thenApply(success -> {
                        if (success.booleanValue()) {
                            if (!silent) {
                                sender.sendMessage(MessageUtils.colorize("&aSuccessfully banned " + targetName + " for: " + reason));
                            }
                        } else {
                            sender.sendMessage(MessageUtils.colorize("&cFailed to ban " + targetName + " for: " + reason));
                        }
                        return success;
                    });
                });
            });
        })).exceptionally(throwable -> {
            this.plugin.getLogger().severe("Error processing ban command: " + throwable.getMessage());
            sender.sendMessage(MessageUtils.colorize("&cAn error occurred while processing the ban command."));
            return false;
        });
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                completions.add(player.getName());
            }
        } else if (args.length > 1) {
            String lastArg = args[args.length - 1];
            if (args.length > 2 && args[args.length - 2].equals("-t")) {
                this.templateService.getAllTemplates().forEach(template -> {
                    if (template.getName().toLowerCase().startsWith(lastArg.toLowerCase())) {
                        completions.add(template.getName());
                    }
                });
            } else if (args.length > 2 && args[args.length - 2].equals("-d")) {
                completions.addAll(Arrays.asList("1h", "1d", "1w", "1m", "1y"));
            } else {
                if (!Arrays.asList(args).contains("-s")) {
                    completions.add("-s");
                }
                if (!Arrays.asList(args).contains("-t")) {
                    completions.add("-t");
                }
                if (!Arrays.asList(args).contains("-d")) {
                    completions.add("-d");
                }
                completions.addAll(Arrays.asList("Hacking", "Griefing", "Toxic behavior", "Spam", "Advertising", "Inappropriate language", "Cheating", "Rule violation"));
            }
        }
        return completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

