/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import me.wethink.weGuardian.utils.MessageUtils;
import me.wethink.weGuardian.utils.TimeUtils;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class BanlistCommand
implements CommandExecutor,
TabCompleter {
    private static final int ITEMS_PER_PAGE = 10;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final WeGuardian plugin;

    public BanlistCommand(WeGuardian plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!sender.hasPermission("weguardian.banlist")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        int page = 1;
        String filter = null;
        boolean includeIP = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("--ip")) {
                includeIP = true;
                continue;
            }
            if (arg.equalsIgnoreCase("--page") && i + 1 < args.length) {
                try {
                    page = Integer.parseInt(args[i + 1]);
                    ++i;
                    continue;
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(MessageUtils.colorize("&cInvalid page number: " + args[i + 1]));
                    return true;
                }
            }
            if (arg.equalsIgnoreCase("--filter") && i + 1 < args.length) {
                filter = args[i + 1];
                ++i;
                continue;
            }
            if (!arg.matches("\\d+")) continue;
            try {
                page = Integer.parseInt(arg);
                continue;
            }
            catch (NumberFormatException e) {
                sender.sendMessage(MessageUtils.colorize("&cInvalid page number: " + arg));
                return true;
            }
        }
        int finalPage = page;
        String finalFilter = filter;
        boolean finalIncludeIP = includeIP;
        ((CompletableFuture)this.plugin.getDatabaseManager().getAllActivePunishments().thenAccept(punishments -> {
            List bans = punishments.stream().filter(p -> p.getType() == PunishmentType.BAN || finalIncludeIP && p.getType() == PunishmentType.IPBAN).filter(p -> finalFilter == null || p.getTargetName().toLowerCase().contains(finalFilter.toLowerCase()) || p.getReason().toLowerCase().contains(finalFilter.toLowerCase())).collect(Collectors.toList());
            if (bans.isEmpty()) {
                sender.sendMessage(MessageUtils.colorize("&aNo active bans found" + (String)(finalFilter != null ? " matching filter '" + finalFilter + "'" : "") + "."));
                return;
            }
            int totalPages = (int)Math.ceil((double)bans.size() / 10.0);
            int startIndex = (finalPage - 1) * 10;
            int endIndex = Math.min(startIndex + 10, bans.size());
            if (finalPage > totalPages) {
                sender.sendMessage(MessageUtils.colorize("&cPage " + finalPage + " does not exist. Maximum page: " + totalPages));
                return;
            }
            sender.sendMessage(MessageUtils.colorize("&6&l=== Ban List (Page " + finalPage + "/" + totalPages + ") ==="));
            if (finalFilter != null) {
                sender.sendMessage(MessageUtils.colorize("&7Filter: &f" + finalFilter));
            }
            if (finalIncludeIP) {
                sender.sendMessage(MessageUtils.colorize("&7Including IP bans"));
            }
            sender.sendMessage(MessageUtils.colorize("&7Total bans: &f" + bans.size()));
            sender.sendMessage("");
            for (int i = startIndex; i < endIndex; ++i) {
                Punishment ban = (Punishment)bans.get(i);
                String target = ban.isIPBased() ? ban.getTargetIP() : ban.getTargetName();
                String type = ban.getType() == PunishmentType.IPBAN ? "IP" : "Player";
                String banType = ban.getExpiresAt() != null ? "Temporary" : "Permanent";
                BuildableComponent banInfo = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)(i + 1 + ". ")).color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)target).color(TextColor.fromHexString((String)"FFA07A")))).append(Component.text((String)(" (" + type + " - " + banType + ")")).color(TextColor.fromHexString((String)"808080")))).build();
                BuildableComponent hoverText = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"Target: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)target).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nStaff: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)ban.getStaffName()).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nReason: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)ban.getReason()).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nDate: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)ban.getCreatedAt().format(DATE_FORMAT)).color(TextColor.fromHexString((String)"FFFFFF")))).build();
                if (ban.getExpiresAt() != null) {
                    long timeLeft = Duration.between(LocalDateTime.now(), ban.getExpiresAt()).toMillis();
                    hoverText = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"Target: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)target).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nStaff: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)ban.getStaffName()).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nReason: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)ban.getReason()).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nDate: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)ban.getCreatedAt().format(DATE_FORMAT)).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nExpires: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)ban.getExpiresAt().format(DATE_FORMAT)).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nTime Left: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)TimeUtils.formatDuration(timeLeft)).color(TextColor.fromHexString((String)"FFFFFF")))).build();
                } else {
                    hoverText = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"Target: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)target).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nStaff: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)ban.getStaffName()).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nReason: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)ban.getReason()).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nDate: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)ban.getCreatedAt().format(DATE_FORMAT)).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nType: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)"Permanent").color(TextColor.fromHexString((String)"FF0000")))).build();
                }
                banInfo = banInfo.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverText)).clickEvent(ClickEvent.suggestCommand((String)("/blame " + ban.getId())));
                sender.sendMessage((Component)banInfo);
            }
            TextComponent footer = Component.text((String)"");
            if (finalPage > 1) {
                footer = footer.append(((TextComponent)((TextComponent)Component.text((String)"[\u25c0 Previous]").color(TextColor.fromHexString((String)"00FF00"))).clickEvent(ClickEvent.runCommand((String)("/banlist " + (finalPage - 1) + (finalIncludeIP ? " --ip" : "") + (String)(finalFilter != null ? " --filter " + finalFilter : ""))))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Go to page " + (finalPage - 1))))));
            }
            footer = footer.append(Component.text((String)(" Page " + finalPage + "/" + totalPages + " ")).color(TextColor.fromHexString((String)"AAAAAA")));
            if (finalPage < totalPages) {
                footer = footer.append(((TextComponent)((TextComponent)Component.text((String)"[Next \u25b6]").color(TextColor.fromHexString((String)"00FF00"))).clickEvent(ClickEvent.runCommand((String)("/banlist " + (finalPage + 1) + (finalIncludeIP ? " --ip" : "") + (String)(finalFilter != null ? " --filter " + finalFilter : ""))))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Go to page " + (finalPage + 1))))));
            }
            sender.sendMessage((Component)footer);
        })).exceptionally(throwable -> {
            sender.sendMessage(MessageUtils.colorize("&cError retrieving ban list: " + throwable.getMessage()));
            this.plugin.getLogger().severe("Error in banlist command: " + throwable.getMessage());
            return null;
        });
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("--ip", "--page", "--filter", "1", "2", "3"));
        } else if (args.length == 2 && args[0].equalsIgnoreCase("--page")) {
            completions.addAll(Arrays.asList("1", "2", "3", "4", "5"));
        } else if (args.length == 2 && args[0].equalsIgnoreCase("--filter")) {
            completions.add("<player_name>");
        }
        return completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

