/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.gui.menus;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.gui.MenuHandler;
import me.wethink.weGuardian.gui.menus.MenuManager;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TempmuteMenu
extends MenuHandler {
    private final MenuManager menuManager;

    public TempmuteMenu(WeGuardian plugin, MenuManager menuManager) {
        super(plugin, "tempmute");
        this.menuManager = menuManager;
    }

    protected MenuManager getMenuManager() {
        return this.menuManager;
    }

    @Override
    protected ConfigurationSection getMenuConfig() {
        return this.plugin.getGUIConfigLoader().getGUIConfig("tempmute");
    }

    @Override
    protected void handleItemClick(Player staff, String targetPlayer, String itemKey, ConfigurationSection itemConfig) {
        Map<String, Object> selectedData;
        String menuType;
        String action = itemConfig.getString("action", "");
        if (this.plugin.getConfig().getBoolean("debug.enabled", false)) {
            this.plugin.getLogger().info("TempmuteMenu: Player " + staff.getName() + " clicked item " + itemKey + " with action: " + action);
        }
        if (action.startsWith("set_duration:")) {
            String duration = action.substring("set_duration:".length());
            Map<String, Object> selectedData2 = this.getSelectedData(staff);
            selectedData2.put("selectedDuration", duration);
            staff.sendMessage(MessageUtils.colorize("&eSelected duration: &f" + duration));
            this.preserveSelectionOnNextClose(staff);
            this.refreshInventory(staff, targetPlayer);
            return;
        }
        if (action.startsWith("execute_punishment:")) {
            String[] parts = action.split(":", 4);
            if (parts.length >= 4) {
                String reason = parts[2];
                String duration = parts[3];
                Map<String, Object> selectedData3 = this.getSelectedData(staff);
                String selectedDuration = (String)selectedData3.get("selectedDuration");
                if (selectedDuration != null && duration.contains("{selected_duration}")) {
                    duration = duration.replace("{selected_duration}", selectedDuration);
                    this.executeTempmute(staff, targetPlayer, reason, duration);
                    return;
                }
                if (!duration.contains("{selected_duration}")) {
                    this.executeTempmute(staff, targetPlayer, reason, duration);
                    return;
                }
                staff.sendMessage(MessageUtils.colorize("&cPlease select a duration first!"));
                return;
            }
            if (parts.length >= 3) {
                String reason = parts[2];
                Map<String, Object> selectedData4 = this.getSelectedData(staff);
                String selectedDuration = (String)selectedData4.get("selectedDuration");
                if (selectedDuration != null) {
                    this.executeTempmute(staff, targetPlayer, reason, selectedDuration);
                    return;
                }
                staff.sendMessage(MessageUtils.colorize("&cPlease select a duration first!"));
                return;
            }
        }
        if (action.startsWith("open_menu:") && (menuType = action.substring("open_menu:".length())).equals("main")) {
            this.getMenuManager().setActiveMenu(staff, this.getMenuManager().getMainMenu());
            this.getMenuManager().getMainMenu().openMenu(staff, targetPlayer);
            return;
        }
        if (action.equals("back") || itemKey.equals("back")) {
            this.getMenuManager().setActiveMenu(staff, this.getMenuManager().getMainMenu());
            this.getMenuManager().getMainMenu().openMenu(staff, targetPlayer);
            return;
        }
        if (action.equals("close") || itemKey.equals("close")) {
            staff.closeInventory();
            return;
        }
        if (action.startsWith("custom_reason:")) {
            selectedData = this.getSelectedData(staff);
            String selectedDuration = (String)selectedData.get("selectedDuration");
            if (selectedDuration != null) {
                staff.sendMessage(MessageUtils.colorize("&eCustom input feature coming in next update!"));
                staff.sendMessage(MessageUtils.colorize("&7For now, please use the predefined options."));
            } else {
                staff.sendMessage(MessageUtils.colorize("&cPlease select a duration first!"));
            }
            return;
        }
        selectedData = this.getSelectedData(staff);
        if (itemConfig.contains("duration")) {
            String duration = itemConfig.getString("duration", "30m");
            selectedData.put("selectedDuration", duration);
            staff.sendMessage(MessageUtils.colorize("&eSelected duration: &f" + duration));
            this.preserveSelectionOnNextClose(staff);
            this.refreshInventory(staff, targetPlayer);
            return;
        }
        if (itemConfig.contains("reason")) {
            String reason = itemConfig.getString("reason", "No reason specified");
            String selectedDuration = (String)selectedData.get("selectedDuration");
            if (selectedDuration != null) {
                this.executeTempmute(staff, targetPlayer, reason, selectedDuration);
            } else {
                staff.sendMessage(MessageUtils.colorize("&cPlease select a duration first!"));
            }
            return;
        }
    }

    private void refreshInventory(Player staff, String targetPlayer) {
        staff.closeInventory();
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.openMenu(staff, targetPlayer), 1L);
    }

    private void executeTempmute(Player staff, String targetPlayer, String reason, String duration) {
        staff.closeInventory();
        this.clearSelectedData(staff);
        staff.sendMessage(MessageUtils.colorize("&eExecuting tempmute on &a" + targetPlayer + " &efor " + duration + ": &f" + reason));
        ((CompletableFuture)this.plugin.getPunishmentService().tempmute(targetPlayer, staff.getName(), reason, duration).thenAccept(success -> {
            if (success.booleanValue()) {
                staff.sendMessage(MessageUtils.colorize("&aSuccessfully tempmuted " + targetPlayer + " for " + duration + ": &e" + reason));
            } else {
                staff.sendMessage(MessageUtils.colorize("&cFailed to tempmute " + targetPlayer + ". Player may already be muted."));
            }
        })).exceptionally(throwable -> {
            this.plugin.getLogger().severe("Error executing tempmute: " + throwable.getMessage());
            staff.sendMessage(MessageUtils.colorize("&cAn error occurred while executing the tempmute."));
            return null;
        });
    }

    @Override
    protected void onMenuOpen(Player staff, String targetPlayer) {
        if (this.plugin.getConfig().getBoolean("debug.enabled", false)) {
            this.plugin.debug("Staff %s opened tempmute menu for %s", staff.getName(), targetPlayer);
        }
    }
}

