/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.services;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import me.wethink.weGuardian.utils.MessageUtils;
import me.wethink.weguardian.lib.folialib.wrapper.task.WrappedTask;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class NotificationService {
    private final WeGuardian plugin;
    private final Map<UUID, WrappedTask> actionBarTasks = new ConcurrentHashMap<UUID, WrappedTask>();
    private final ScheduledExecutorService executorService;

    public NotificationService(WeGuardian plugin) {
        this.plugin = plugin;
        this.executorService = Executors.newScheduledThreadPool(2);
    }

    private String getMessageTemplate(String context, PunishmentType type) {
        String messageKey = switch (context) {
            case "chat" -> "chat." + type.name().toLowerCase();
            case "reconnect_attempt" -> "chat.reconnect_attempt";
            case "chat_attempt" -> "chat.chat_attempt";
            default -> "defaults.generic_punishment";
        };
        return this.plugin.getMessage(messageKey);
    }

    private String getUnpunishmentTemplate(PunishmentType type) {
        String messageKey = switch (type) {
            case PunishmentType.BAN, PunishmentType.TEMPBAN -> "chat.unban";
            case PunishmentType.MUTE, PunishmentType.TEMPMUTE -> "chat.unmute";
            default -> "defaults.generic_unban";
        };
        return this.plugin.getMessage(messageKey);
    }

    public void broadcastPunishment(Punishment punishment) {
        this.plugin.debug("Broadcasting punishment notification: type=%s, target=%s, staff=%s", new Object[]{punishment.getType(), punishment.getTargetName(), punishment.getStaffName()});
        this.broadcastPunishment(punishment, "chat");
    }

    public void broadcastPunishment(Punishment punishment, String context) {
        if (!this.plugin.getConfig().getBoolean("notifications.chat.enabled", true)) {
            this.plugin.debug("Punishment notification skipped: chat notifications disabled");
            return;
        }
        String template = this.getMessageTemplate(context, punishment.getType());
        String message = MessageUtils.formatPunishmentMessage(template, punishment);
        this.plugin.debug("Formatted punishment message: %s", message);
        String permission = this.plugin.getConfig().getString("notifications.chat.broadcast_permission", "weguardian.notify");
        this.plugin.debug("Broadcasting to staff with permission: %s", permission);
        this.broadcastToStaff(message, permission);
        this.logToConsole(message);
    }

    public void broadcastUnpunishment(Punishment punishment, String staffName) {
        if (!this.plugin.getConfig().getBoolean("notifications.chat.enabled", true)) {
            return;
        }
        String template = this.getUnpunishmentTemplate(punishment.getType());
        String message = template.replace("{player}", punishment.getTargetName()).replace("{staff}", staffName);
        message = MessageUtils.colorize(message);
        String permission = this.plugin.getConfig().getString("notifications.chat.broadcast_permission", "weguardian.notify");
        this.broadcastToStaff(message, permission);
        this.logToConsole(message);
    }

    public void broadcastUnpunishment(Punishment punishment, String staffName, String reason) {
        this.broadcastUnpunishment(punishment, staffName);
    }

    public void sendActionBarMessage(Player player, Punishment punishment) {
        String template = this.getMessageTemplate("actionbar", punishment.getType());
        String message = MessageUtils.formatPunishmentMessage(template, punishment);
        if (!message.isEmpty()) {
            Component component = MessageUtils.toComponent(message);
            player.sendActionBar(component);
        }
    }

    private void startActionBarUpdates(Punishment punishment) {
        if (!this.plugin.getConfig().getBoolean("notifications.actionbar_updates", true)) {
            return;
        }
        if (punishment.getType() != PunishmentType.TEMPBAN && punishment.getType() != PunishmentType.TEMPMUTE) {
            return;
        }
        UUID targetUuid = punishment.getTargetUuid();
        this.stopActionBarUpdates(targetUuid);
        int interval = this.plugin.getConfig().getInt("notifications.actionbar_interval", 30) * 20;
        WrappedTask task = this.plugin.getFoliaLib().getScheduler().runTimer(() -> {
            Player player = Bukkit.getPlayer((UUID)targetUuid);
            if (player == null) {
                this.stopActionBarUpdates(targetUuid);
                return;
            }
            if (punishment.isExpired()) {
                this.stopActionBarUpdates(targetUuid);
                return;
            }
            this.sendActionBarMessage(player, punishment);
        }, 0L, (long)interval);
        this.actionBarTasks.put(targetUuid, task);
    }

    private void stopActionBarUpdates(UUID playerUuid) {
        WrappedTask task = this.actionBarTasks.remove(playerUuid);
        if (task != null) {
            this.plugin.getFoliaLib().getScheduler().cancelTask(task);
        }
    }

    private void broadcastToStaff(String message, String permission) {
        Component component = MessageUtils.toComponent(message);
        int notifiedCount = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission(permission)) continue;
            player.sendMessage(component);
            ++notifiedCount;
        }
        this.plugin.debug("Notified %d staff members with permission: %s", notifiedCount, permission);
    }

    private void logToConsole(String message) {
        this.plugin.getLogger().info(message);
    }

    public void shutdown() {
        for (WrappedTask task : this.actionBarTasks.values()) {
            this.plugin.getFoliaLib().getScheduler().cancelTask(task);
        }
        this.actionBarTasks.clear();
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

