/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import me.wethink.weGuardian.utils.MessageUtils;
import me.wethink.weGuardian.utils.TimeUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CheckbanCommand
implements CommandExecutor,
TabCompleter {
    private final WeGuardian plugin;

    public CheckbanCommand(WeGuardian plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("weguardian.checkban")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(MessageUtils.colorize("&cUsage: /checkban <player>"));
            return true;
        }
        String targetName = args[0];
        this.plugin.getDatabaseManager().getPlayerData(targetName).thenAccept(playerData -> {
            if (playerData == null) {
                sender.sendMessage(MessageUtils.colorize("&cPlayer not found in database."));
                return;
            }
            sender.sendMessage(MessageUtils.colorize("&6&l=== Punishment Status for " + targetName + " ==="));
            CompletionStage banCheck = this.plugin.getDatabaseManager().getActivePunishment(playerData.getUuid(), PunishmentType.BAN).thenCompose(ban -> ban != null ? CompletableFuture.completedFuture(ban) : this.plugin.getDatabaseManager().getActivePunishment(playerData.getUuid(), PunishmentType.TEMPBAN));
            CompletionStage muteCheck = this.plugin.getDatabaseManager().getActivePunishment(playerData.getUuid(), PunishmentType.MUTE).thenCompose(mute -> mute != null ? CompletableFuture.completedFuture(mute) : this.plugin.getDatabaseManager().getActivePunishment(playerData.getUuid(), PunishmentType.TEMPMUTE));
            CompletableFuture.allOf(new CompletableFuture[]{banCheck, muteCheck}).thenRun(() -> this.lambda$onCommand$2((CompletableFuture)banCheck, (CompletableFuture)muteCheck, sender));
        });
        return true;
    }

    private void displayPunishmentInfo(CommandSender sender, Punishment punishment, String type) {
        sender.sendMessage(MessageUtils.colorize("&c\u2717 " + type + " STATUS: &4ACTIVE"));
        sender.sendMessage(MessageUtils.colorize("&7  Reason: &f" + punishment.getReason()));
        sender.sendMessage(MessageUtils.colorize("&7  Staff: &f" + punishment.getStaffName()));
        sender.sendMessage(MessageUtils.colorize("&7  Date: &f" + TimeUtils.formatDateTime(punishment.getCreatedAt())));
        if (punishment.getExpiresAt() != null) {
            if (punishment.getExpiresAt().isAfter(LocalDateTime.now())) {
                String timeLeft = TimeUtils.getRemainingTime(punishment.getExpiresAt());
                sender.sendMessage(MessageUtils.colorize("&7  Expires: &f" + TimeUtils.formatDateTime(punishment.getExpiresAt()) + " &8(" + timeLeft + " remaining)"));
            } else {
                sender.sendMessage(MessageUtils.colorize("&7  Status: &c&lEXPIRED &8(should be auto-removed)"));
            }
        } else {
            sender.sendMessage(MessageUtils.colorize("&7  Duration: &fPermanent"));
        }
        sender.sendMessage("");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private /* synthetic */ void lambda$onCommand$2(CompletableFuture banCheck, CompletableFuture muteCheck, CommandSender sender) {
        try {
            Punishment banPunishment = (Punishment)banCheck.get();
            Punishment mutePunishment = (Punishment)muteCheck.get();
            if (banPunishment == null && mutePunishment == null) {
                sender.sendMessage(MessageUtils.colorize("&a\u2713 Player is not banned or muted"));
                return;
            }
            if (banPunishment != null) {
                this.displayPunishmentInfo(sender, banPunishment, "BAN");
            }
            if (mutePunishment != null) {
                this.displayPunishmentInfo(sender, mutePunishment, "MUTE");
            }
        }
        catch (Exception e) {
            sender.sendMessage(MessageUtils.colorize("&cError checking punishment status."));
        }
    }
}

