/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.database;

import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.models.BanwaveEntry;
import me.wethink.weGuardian.models.PlayerData;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;

public interface DatabaseManager {
    public CompletableFuture<Void> initialize();

    public CompletableFuture<Boolean> connect();

    public CompletableFuture<Void> disconnect();

    public CompletableFuture<Void> createTables();

    public void close();

    public CompletableFuture<PlayerData> getPlayerData(UUID var1);

    public CompletableFuture<PlayerData> getPlayerData(String var1);

    public CompletableFuture<Void> savePlayerData(PlayerData var1);

    public CompletableFuture<Void> updatePlayerName(UUID var1, String var2);

    public CompletableFuture<Integer> addPunishment(Punishment var1);

    public CompletableFuture<Punishment> getPunishment(int var1);

    public CompletableFuture<Punishment> getPunishmentById(int var1);

    public CompletableFuture<List<Punishment>> getActivePunishments(UUID var1);

    public CompletableFuture<List<Punishment>> getPunishmentHistory(UUID var1);

    public CompletableFuture<List<Punishment>> getPunishmentHistory(UUID var1, PunishmentType var2);

    public CompletableFuture<List<Punishment>> getPunishmentsByType(UUID var1, PunishmentType var2);

    public CompletableFuture<Punishment> getActivePunishment(UUID var1, PunishmentType var2);

    public CompletableFuture<Void> removePunishment(int var1, UUID var2, String var3, String var4);

    public CompletableFuture<Void> expirePunishments();

    public CompletableFuture<Integer> getStaffPunishmentCount(UUID var1, PunishmentType var2);

    public CompletableFuture<Integer> getTotalPunishmentCount(PunishmentType var1);

    public CompletableFuture<List<Punishment>> getRecentPunishments(int var1);

    public CompletableFuture<List<Punishment>> getPunishmentsByStaff(String var1);

    public CompletableFuture<List<Punishment>> getAllPunishments();

    public CompletableFuture<Integer> addBanwaveEntry(BanwaveEntry var1);

    public CompletableFuture<List<BanwaveEntry>> getPendingBanwaveEntries();

    public CompletableFuture<Void> executeBanwaveEntry(int var1);

    public CompletableFuture<Void> removeBanwaveEntry(int var1);

    public CompletableFuture<Boolean> isPlayerBanned(UUID var1);

    public CompletableFuture<Boolean> isPlayerMuted(UUID var1);

    public CompletableFuture<Boolean> isIPMuted(String var1);

    public CompletableFuture<Boolean> isIPBanned(String var1);

    public CompletableFuture<List<String>> searchPlayers(String var1);

    public CompletableFuture<List<PlayerData>> searchPlayersByName(String var1);

    public CompletableFuture<Integer> getTotalPunishments();

    public CompletableFuture<List<PlayerConnection>> getPlayerConnections(UUID var1);

    public CompletableFuture<List<PlayerConnection>> getPlayersFromIP(String var1);

    public CompletableFuture<Void> recordPlayerConnection(UUID var1, String var2, String var3);

    public CompletableFuture<List<Punishment>> getAllActivePunishments();

    public static interface PlayerConnection {
        public UUID getUuid();

        public String getPlayerName();

        public String getIp();

        public LocalDateTime getTimestamp();
    }
}

