/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.database.DatabaseManager;
import me.wethink.weGuardian.models.PlayerData;
import me.wethink.weGuardian.models.PunishmentTemplate;
import me.wethink.weGuardian.services.TemplateService;
import me.wethink.weguardian.lib.folialib.FoliaLib;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.TabCompleteEvent;

public class AsyncSuggestionsListener
implements Listener {
    private final WeGuardian plugin;
    private final DatabaseManager databaseManager;
    private final TemplateService templateService;
    private final FoliaLib foliaLib;
    private final Map<String, List<String>> playerSuggestionsCache = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, Long> cacheTimestamps = new ConcurrentHashMap<String, Long>();
    private static final long CACHE_DURATION = 30000L;
    private final Map<String, List<String>> templateSuggestionsCache = new ConcurrentHashMap<String, List<String>>();
    private long lastTemplateCacheUpdate = 0L;
    private static final long TEMPLATE_CACHE_DURATION = 60000L;

    public AsyncSuggestionsListener(WeGuardian plugin, DatabaseManager databaseManager, TemplateService templateService) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
        this.templateService = templateService;
        this.foliaLib = plugin.getFoliaLib();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onTabComplete(TabCompleteEvent event) {
        String command = event.getBuffer().toLowerCase().trim();
        String[] args = command.split("\\s+");
        if (args.length < 2) {
            return;
        }
        String commandName = args[0].substring(1);
        String currentArg = args[args.length - 1].toLowerCase();
        if (this.isWeGuardianCommand(commandName)) {
            event.getCompletions().clear();
            this.foliaLib.getScheduler().runAsync(task -> {
                try {
                    List<String> suggestions = this.generateSuggestions(event.getSender(), commandName, args, currentArg);
                    if (!suggestions.isEmpty()) {
                        this.foliaLib.getScheduler().runNextTick(task2 -> event.getCompletions().addAll(suggestions));
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error generating async suggestions: " + e.getMessage());
                }
            });
        }
    }

    private boolean isWeGuardianCommand(String commandName) {
        return Arrays.asList("ban", "tempban", "mute", "tempmute", "kick", "warn", "unban", "unmute", "ipban", "ipmute", "history", "checkban", "banlist", "mutelist", "blame", "alts", "warns", "unwarn", "banmenu", "tempbanmenu", "mutemenu", "tempmutemenu", "kickmenu", "warnmenu", "notesmenu", "unbanmenu", "unmutemenu", "punish", "weguardian").contains(commandName);
    }

    private List<String> generateSuggestions(CommandSender sender, String commandName, String[] args, String currentArg) {
        ArrayList<String> suggestions = new ArrayList<String>();
        switch (commandName) {
            case "ban": 
            case "tempban": 
            case "mute": 
            case "tempmute": 
            case "kick": 
            case "warn": 
            case "unban": 
            case "unmute": 
            case "history": 
            case "checkban": 
            case "blame": 
            case "alts": 
            case "warns": 
            case "unwarn": 
            case "punish": {
                if (args.length == 2) {
                    suggestions.addAll(this.getPlayerSuggestions(currentArg, sender));
                    break;
                }
                if (args.length <= 2) break;
                suggestions.addAll(this.getAdvancedSuggestions(sender, commandName, args, currentArg));
                break;
            }
            case "ipban": 
            case "ipmute": {
                if (args.length == 2) {
                    suggestions.addAll(this.getIPSuggestions(currentArg));
                    break;
                }
                if (args.length <= 2) break;
                suggestions.addAll(this.getReasonSuggestions(currentArg));
                break;
            }
            case "banlist": 
            case "mutelist": {
                if (args.length != 2) break;
                suggestions.addAll(this.getPaginationSuggestions(currentArg));
                break;
            }
            case "weguardian": {
                if (args.length != 2) break;
                suggestions.addAll(this.getMainCommandSuggestions(currentArg));
            }
        }
        return suggestions.stream().filter(suggestion -> suggestion.toLowerCase().startsWith(currentArg)).limit(20L).collect(Collectors.toList());
    }

    private List<String> getPlayerSuggestions(String currentArg, CommandSender sender) {
        List<String> cached;
        String cacheKey = "players_" + currentArg;
        if (this.isCacheValid(cacheKey) && (cached = this.playerSuggestionsCache.get(cacheKey)) != null) {
            return cached;
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (!onlinePlayer.getName().toLowerCase().startsWith(currentArg)) continue;
            suggestions.add(onlinePlayer.getName());
        }
        if (suggestions.size() < 10) {
            try {
                List<PlayerData> offlinePlayers = this.databaseManager.searchPlayersByName(currentArg).join();
                for (PlayerData playerData : offlinePlayers) {
                    if (!playerData.getName().toLowerCase().startsWith(currentArg)) continue;
                    suggestions.add(playerData.getName());
                }
            }
            catch (Exception e) {
                this.plugin.debug("Error fetching offline players for suggestions: %s", e.getMessage());
            }
        }
        this.playerSuggestionsCache.put(cacheKey, suggestions);
        this.cacheTimestamps.put(cacheKey, System.currentTimeMillis());
        return suggestions;
    }

    private List<String> getAdvancedSuggestions(CommandSender sender, String commandName, String[] args, String currentArg) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length > 3 && args[args.length - 2].equals("-t")) {
            return this.getTemplateSuggestions(currentArg);
        }
        if (args.length > 3 && args[args.length - 2].equals("-d")) {
            return this.getDurationSuggestions();
        }
        if (!Arrays.asList(args).contains("-s")) {
            suggestions.add("-s");
        }
        if (!Arrays.asList(args).contains("-t")) {
            suggestions.add("-t");
        }
        if (!Arrays.asList(args).contains("-d") && (commandName.equals("ban") || commandName.equals("mute"))) {
            suggestions.add("-d");
        }
        if (!Arrays.asList(args).contains("--ip") && this.hasIPPermission(sender, commandName)) {
            suggestions.add("--ip");
        }
        suggestions.addAll(this.getReasonSuggestions(currentArg));
        return suggestions;
    }

    private List<String> getTemplateSuggestions(String currentArg) {
        if (System.currentTimeMillis() - this.lastTemplateCacheUpdate > 60000L) {
            this.updateTemplateCache();
        }
        return ((List)this.templateSuggestionsCache.getOrDefault("all", new ArrayList())).stream().filter(template -> template.toLowerCase().startsWith(currentArg)).collect(Collectors.toList());
    }

    private void updateTemplateCache() {
        try {
            Collection<PunishmentTemplate> templates = this.templateService.getAllTemplates();
            List templateNames = templates.stream().map(PunishmentTemplate::getName).collect(Collectors.toList());
            this.templateSuggestionsCache.put("all", templateNames);
            this.lastTemplateCacheUpdate = System.currentTimeMillis();
        }
        catch (Exception e) {
            this.plugin.debug("Error updating template cache: %s", e.getMessage());
        }
    }

    private List<String> getDurationSuggestions() {
        return Arrays.asList("1h", "2h", "6h", "12h", "1d", "2d", "3d", "7d", "14d", "30d", "1w", "2w", "1m", "3m", "6m", "1y");
    }

    private List<String> getReasonSuggestions(String currentArg) {
        return Arrays.asList("Hacking", "Griefing", "Toxic behavior", "Spam", "Advertising", "Inappropriate language", "Cheating", "Rule violation", "X-ray", "Duping", "Exploiting", "Alt account", "Disrespect", "Harassment", "Chat abuse", "Excessive caps", "Flooding", "Political discussion");
    }

    private List<String> getIPSuggestions(String currentArg) {
        if (currentArg.matches("^\\d{1,3}$")) {
            return Arrays.asList(currentArg + ".", currentArg + "0", currentArg + "1", currentArg + "2");
        }
        if (currentArg.matches("^\\d{1,3}\\.\\d{1,3}$")) {
            return Arrays.asList(currentArg + ".", currentArg + "0", currentArg + "1", currentArg + "2");
        }
        if (currentArg.matches("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$")) {
            return Arrays.asList(currentArg + ".", currentArg + "0", currentArg + "1", currentArg + "2");
        }
        return new ArrayList<String>();
    }

    private List<String> getPaginationSuggestions(String currentArg) {
        return Arrays.asList("1", "2", "3", "4", "5", "10", "20", "50", "100");
    }

    private List<String> getMainCommandSuggestions(String currentArg) {
        return Arrays.asList("reload", "about", "version", "help");
    }

    private boolean hasIPPermission(CommandSender sender, String commandName) {
        return switch (commandName) {
            case "mute", "tempmute" -> sender.hasPermission("weguardian.ipmute");
            case "kick" -> sender.hasPermission("weguardian.ipkick");
            default -> false;
        };
    }

    private boolean isCacheValid(String cacheKey) {
        Long timestamp = this.cacheTimestamps.get(cacheKey);
        return timestamp != null && System.currentTimeMillis() - timestamp < 30000L;
    }

    public void clearCache() {
        this.playerSuggestionsCache.clear();
        this.templateSuggestionsCache.clear();
        this.cacheTimestamps.clear();
        this.lastTemplateCacheUpdate = 0L;
    }
}

