/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.services;

import java.io.File;
import java.util.List;
import me.wethink.weGuardian.WeGuardian;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class MenuValidationService {
    private final WeGuardian plugin;
    private final boolean validationEnabled;
    private final boolean checkMenuLinks;
    private final boolean checkItemMaterials;
    private final boolean checkActionFormats;
    private final boolean autoFixIssues;

    public MenuValidationService(WeGuardian plugin) {
        this.plugin = plugin;
        ConfigurationSection config = plugin.getConfig().getConfigurationSection("menus.validation");
        this.validationEnabled = config != null && config.getBoolean("enabled", true);
        this.checkMenuLinks = config != null && config.getBoolean("check_menu_links", true);
        this.checkItemMaterials = config != null && config.getBoolean("check_item_materials", true);
        this.checkActionFormats = config != null && config.getBoolean("check_action_formats", true);
        boolean bl = this.autoFixIssues = config != null && config.getBoolean("auto_fix_issues", false);
        if (this.validationEnabled) {
            plugin.debug("Menu validation service initialized");
            this.validateAllMenus();
        } else {
            plugin.debug("Menu validation disabled");
        }
    }

    public void validateAllMenus() {
        if (!this.validationEnabled) {
            return;
        }
        this.plugin.debug("Starting menu validation process");
        List availableMenus = this.plugin.getConfig().getStringList("menus.available_menus");
        File guiDir = new File(this.plugin.getDataFolder(), "gui");
        if (!guiDir.exists()) {
            this.plugin.getLogger().warning("GUI directory not found: " + guiDir.getAbsolutePath());
            return;
        }
        for (String menuName : availableMenus) {
            File menuFile = new File(guiDir, menuName + ".yml");
            if (menuFile.exists()) {
                this.validateMenuFile(menuName, menuFile);
                continue;
            }
            this.plugin.getLogger().warning("Menu file not found: " + menuFile.getName());
        }
        this.plugin.debug("Menu validation process completed");
    }

    private void validateMenuFile(String menuName, File menuFile) {
        this.plugin.debug("Validating menu file: %s", menuFile.getName());
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)menuFile);
            this.validateMenuSize(menuName, config);
            ConfigurationSection items = config.getConfigurationSection("items");
            if (items != null) {
                for (String itemKey : items.getKeys(false)) {
                    ConfigurationSection itemConfig = items.getConfigurationSection(itemKey);
                    if (itemConfig == null) continue;
                    this.validateMenuItem(menuName, itemKey, itemConfig);
                }
            } else {
                this.plugin.getLogger().warning("No items found in menu: " + menuName);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error validating menu file " + menuFile.getName() + ": " + e.getMessage());
            this.plugin.debug("Menu validation error for %s: %s", menuName, e.getMessage());
        }
    }

    private void validateMenuSize(String menuName, YamlConfiguration config) {
        List validSizes;
        int size = config.getInt("size", 0);
        if (size == 0) {
            size = config.getInt("settings.size", 0);
        }
        if (!(validSizes = this.plugin.getConfig().getIntegerList("menus.size_validation.valid_sizes")).contains(size)) {
            this.plugin.getLogger().warning("Invalid menu size for " + menuName + ": " + size + " (must be one of: " + String.valueOf(validSizes) + ")");
            if (this.autoFixIssues) {
                int defaultSize = this.plugin.getConfig().getInt("menus.size_validation.default_sizes." + menuName, 45);
                config.set("size", (Object)defaultSize);
                this.plugin.debug("Auto-fixed menu size for %s to %d", menuName, defaultSize);
            }
        }
    }

    private void validateMenuItem(String menuName, String itemKey, ConfigurationSection itemConfig) {
        this.validateRequiredProperties(menuName, itemKey, itemConfig);
        if (this.checkItemMaterials) {
            this.validateItemMaterial(menuName, itemKey, itemConfig);
        }
        if (this.checkActionFormats) {
            this.validateItemAction(menuName, itemKey, itemConfig);
        }
        if (this.checkMenuLinks) {
            this.validateMenuLinks(menuName, itemKey, itemConfig);
        }
    }

    private void validateRequiredProperties(String menuName, String itemKey, ConfigurationSection itemConfig) {
        List requiredProps = this.plugin.getConfig().getStringList("menus.item_validation.required_properties");
        for (String prop : requiredProps) {
            if (itemConfig.contains(prop)) continue;
            this.plugin.getLogger().warning("Missing required property '" + prop + "' in menu " + menuName + " item " + itemKey);
            if (!this.autoFixIssues) continue;
            switch (prop) {
                case "material": {
                    itemConfig.set(prop, (Object)"PAPER");
                    break;
                }
                case "slot": {
                    itemConfig.set(prop, (Object)0);
                    break;
                }
                case "name": {
                    itemConfig.set(prop, (Object)("&f" + itemKey));
                    break;
                }
                case "action": {
                    itemConfig.set(prop, (Object)"close");
                }
            }
            this.plugin.debug("Auto-fixed missing property %s for item %s in menu %s", prop, itemKey, menuName);
        }
    }

    private void validateItemMaterial(String menuName, String itemKey, ConfigurationSection itemConfig) {
        block4: {
            String materialName = itemConfig.getString("material");
            if (materialName == null) {
                return;
            }
            List validMaterials = this.plugin.getConfig().getStringList("menus.item_validation.valid_materials");
            try {
                Material.valueOf((String)materialName);
                if (!validMaterials.contains(materialName)) {
                    this.plugin.getLogger().warning("Uncommon material '" + materialName + "' used in menu " + menuName + " item " + itemKey);
                }
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid material '" + materialName + "' in menu " + menuName + " item " + itemKey);
                if (!this.autoFixIssues) break block4;
                itemConfig.set("material", (Object)"PAPER");
                this.plugin.debug("Auto-fixed invalid material for item %s in menu %s", itemKey, menuName);
            }
        }
    }

    private void validateItemAction(String menuName, String itemKey, ConfigurationSection itemConfig) {
        String actionType;
        String action = itemConfig.getString("action");
        if (action == null) {
            return;
        }
        List validActions = this.plugin.getConfig().getStringList("menus.link_validation.valid_actions");
        if (!validActions.contains(actionType = action.split(":")[0])) {
            this.plugin.getLogger().warning("Invalid action type '" + actionType + "' in menu " + menuName + " item " + itemKey);
            if (this.autoFixIssues) {
                itemConfig.set("action", (Object)"close");
                this.plugin.debug("Auto-fixed invalid action for item %s in menu %s", itemKey, menuName);
            }
            return;
        }
        this.validateActionParameters(menuName, itemKey, action, actionType);
    }

    private void validateActionParameters(String menuName, String itemKey, String action, String actionType) {
        ConfigurationSection actionConfig = this.plugin.getConfig().getConfigurationSection("menus.link_validation.action_requirements." + actionType);
        if (actionConfig == null) {
            return;
        }
        List requiredParams = actionConfig.getStringList("required_params");
        String[] actionParts = action.split(":");
        for (String param : requiredParams) {
            boolean paramFound = false;
            switch (actionType) {
                case "open_menu": {
                    if (!param.equals("menu_type") || actionParts.length <= 1) break;
                    String menuType = actionParts[1];
                    List validMenuTypes = actionConfig.getStringList("valid_menu_types");
                    if (!validMenuTypes.contains(menuType)) {
                        this.plugin.getLogger().warning("Invalid menu type '" + menuType + "' in menu " + menuName + " item " + itemKey);
                    }
                    paramFound = true;
                    break;
                }
                case "execute_punishment": {
                    if (!param.equals("punishment_type") || actionParts.length <= 1) break;
                    String punishmentType = actionParts[1];
                    List validTypes = actionConfig.getStringList("valid_punishment_types");
                    if (!validTypes.contains(punishmentType)) {
                        this.plugin.getLogger().warning("Invalid punishment type '" + punishmentType + "' in menu " + menuName + " item " + itemKey);
                    }
                    paramFound = true;
                    break;
                }
                case "select_duration": {
                    if (!param.equals("duration") || actionParts.length <= 1) break;
                    String duration = actionParts[1];
                    List validDurations = actionConfig.getStringList("valid_durations");
                    if (!validDurations.contains(duration)) {
                        this.plugin.getLogger().warning("Invalid duration '" + duration + "' in menu " + menuName + " item " + itemKey);
                    }
                    paramFound = true;
                }
            }
            if (paramFound) continue;
            this.plugin.getLogger().warning("Missing required parameter '" + param + "' for action '" + actionType + "' in menu " + menuName + " item " + itemKey);
        }
    }

    private void validateMenuLinks(String menuName, String itemKey, ConfigurationSection itemConfig) {
        String action = itemConfig.getString("action");
        if (action == null || !action.startsWith("open_menu:")) {
            return;
        }
        String[] parts = action.split(":");
        if (parts.length < 2) {
            return;
        }
        String targetMenu = parts[1];
        File targetFile = new File(this.plugin.getDataFolder(), "gui/" + targetMenu + ".yml");
        if (!targetFile.exists()) {
            this.plugin.getLogger().warning("Menu link points to non-existent menu: " + targetMenu + " (from " + menuName + " item " + itemKey + ")");
            if (this.autoFixIssues) {
                itemConfig.set("action", (Object)"close");
                this.plugin.debug("Auto-fixed broken menu link for item %s in menu %s", itemKey, menuName);
            }
        }
    }

    public void validateMenuPerformance() {
        if (!this.plugin.getConfig().getBoolean("menus.performance.cache_menu_configs", true)) {
            return;
        }
        this.plugin.debug("Validating menu performance settings");
        File guiDir = new File(this.plugin.getDataFolder(), "gui");
        if (!guiDir.exists()) {
            return;
        }
        File[] menuFiles = guiDir.listFiles((dir, name) -> name.endsWith(".yml"));
        if (menuFiles == null) {
            return;
        }
        int totalItems = 0;
        for (File menuFile : menuFiles) {
            try {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)menuFile);
                ConfigurationSection items = config.getConfigurationSection("items");
                if (items == null) continue;
                totalItems += items.getKeys(false).size();
            }
            catch (Exception e) {
                this.plugin.debug("Error counting items in menu file %s: %s", menuFile.getName(), e.getMessage());
            }
        }
        this.plugin.debug("Menu performance validation: %d menu files, %d total items", menuFiles.length, totalItems);
        if (totalItems > 1000) {
            this.plugin.getLogger().info("Large number of menu items detected (" + totalItems + "). Consider enabling menu caching for better performance.");
        }
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void reloadValidationSettings() {
        this.plugin.debug("Reloading menu validation settings");
    }
}

