/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.utils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtils {
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d+)([smhdwMy])");
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final int MAX_INPUT_LENGTH = 1000;

    public static long parseTimeToSeconds(String timeString) {
        if (timeString == null || timeString.isEmpty() || timeString.length() > 1000) {
            return 0L;
        }
        Matcher matcher = TIME_PATTERN.matcher(timeString.toLowerCase());
        long totalSeconds = 0L;
        while (matcher.find()) {
            String unit;
            int amount = Integer.parseInt(matcher.group(1));
            switch (unit = matcher.group(2)) {
                case "s": {
                    totalSeconds += (long)amount;
                    break;
                }
                case "m": {
                    totalSeconds += (long)amount * 60L;
                    break;
                }
                case "h": {
                    totalSeconds += (long)amount * 3600L;
                    break;
                }
                case "d": {
                    totalSeconds += (long)amount * 86400L;
                    break;
                }
                case "w": {
                    totalSeconds += (long)amount * 604800L;
                    break;
                }
                case "M": {
                    totalSeconds += (long)amount * 2592000L;
                    break;
                }
                case "y": {
                    totalSeconds += (long)amount * 31536000L;
                }
            }
        }
        return totalSeconds;
    }

    public static LocalDateTime parseTime(String timeString) {
        long seconds = TimeUtils.parseTimeToSeconds(timeString);
        if (seconds <= 0L) {
            throw new IllegalArgumentException("Invalid time format");
        }
        return LocalDateTime.now().plusSeconds(seconds);
    }

    public static LocalDateTime parseTimeToExpiration(String timeString) {
        long seconds = TimeUtils.parseTimeToSeconds(timeString);
        if (seconds <= 0L) {
            return null;
        }
        return LocalDateTime.now().plusSeconds(seconds);
    }

    public static String formatDuration(long seconds) {
        long minutes;
        long hours;
        long days;
        long weeks;
        long months;
        if (seconds <= 0L) {
            return "Permanent";
        }
        StringBuilder result = new StringBuilder();
        long years = seconds / 31536000L;
        if (years > 0L) {
            result.append(years).append("y ");
            seconds %= 31536000L;
        }
        if ((months = seconds / 2592000L) > 0L) {
            result.append(months).append("mo ");
            seconds %= 2592000L;
        }
        if ((weeks = seconds / 604800L) > 0L) {
            result.append(weeks).append("w ");
            seconds %= 604800L;
        }
        if ((days = seconds / 86400L) > 0L) {
            result.append(days).append("d ");
            seconds %= 86400L;
        }
        if ((hours = seconds / 3600L) > 0L) {
            result.append(hours).append("h ");
            seconds %= 3600L;
        }
        if ((minutes = seconds / 60L) > 0L) {
            result.append(minutes).append("m ");
            seconds %= 60L;
        }
        if (seconds > 0L) {
            result.append(seconds).append("s");
        }
        return result.toString().trim();
    }

    public static String getRemainingTime(LocalDateTime expiration) {
        if (expiration == null) {
            return "Permanent";
        }
        LocalDateTime now = LocalDateTime.now();
        if (now.isAfter(expiration)) {
            return "Expired";
        }
        long seconds = ChronoUnit.SECONDS.between(now, expiration);
        return TimeUtils.formatDuration(seconds);
    }

    public static String formatDateTime(LocalDateTime dateTime) {
        if (dateTime == null) {
            return "Never";
        }
        return dateTime.format(FORMATTER);
    }

    public static boolean isValidTimeFormat(String timeString) {
        if (timeString == null || timeString.trim().isEmpty() || timeString.length() > 1000) {
            return false;
        }
        return timeString.matches("^\\d+[smhdwMy]$");
    }
}

