/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.web;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.wethink.weGuardian.WeGuardian;

public class SessionManager {
    private final WeGuardian plugin;
    private final Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    private final Map<String, Integer> loginAttempts = new ConcurrentHashMap<String, Integer>();
    private final Map<String, LocalDateTime> lockouts = new ConcurrentHashMap<String, LocalDateTime>();

    public SessionManager(WeGuardian plugin) {
        this.plugin = plugin;
    }

    public boolean authenticate(String username, String password) {
        String configUsername = this.plugin.getConfig().getString("web-dashboard.credentials.username", "admin");
        String configPassword = this.plugin.getConfig().getString("web-dashboard.credentials.password", "supersecret");
        if (username.equals(configUsername) && password.equals(configPassword)) {
            return true;
        }
        this.recordFailedLogin(username);
        return false;
    }

    public String createSession(String username) {
        String sessionId = UUID.randomUUID().toString();
        long timeoutSeconds = this.plugin.getConfig().getLong("web-dashboard.session-timeout", 3600L);
        Session session = new Session(sessionId, username, LocalDateTime.now().plusSeconds(timeoutSeconds));
        this.sessions.put(sessionId, session);
        return sessionId;
    }

    public boolean isValidSession(String sessionId) {
        Session session = this.sessions.get(sessionId);
        if (session == null) {
            return false;
        }
        if (session.isExpired()) {
            this.sessions.remove(sessionId);
            return false;
        }
        return true;
    }

    public void invalidateSession(String sessionId) {
        this.sessions.remove(sessionId);
    }

    public Session getSession(String sessionId) {
        return this.sessions.get(sessionId);
    }

    public void cleanupExpiredSessions() {
        this.sessions.entrySet().removeIf(entry -> ((Session)entry.getValue()).isExpired());
        this.lockouts.entrySet().removeIf(entry -> ((LocalDateTime)entry.getValue()).isBefore(LocalDateTime.now().minusMinutes(5L)));
    }

    private void recordFailedLogin(String username) {
        this.loginAttempts.put(username, this.loginAttempts.getOrDefault(username, 0) + 1);
        int maxAttempts = this.plugin.getConfig().getInt("web-dashboard.security.max-login-attempts", 5);
        if (this.loginAttempts.get(username) >= maxAttempts) {
            int lockoutDuration = this.plugin.getConfig().getInt("web-dashboard.security.lockout-duration", 300);
            this.lockouts.put(username, LocalDateTime.now().plusSeconds(lockoutDuration));
            this.plugin.getLogger().warning("Account locked for " + username + " due to too many failed login attempts");
        }
    }

    public boolean isAccountLocked(String username) {
        LocalDateTime lockoutTime = this.lockouts.get(username);
        if (lockoutTime == null) {
            return false;
        }
        if (lockoutTime.isBefore(LocalDateTime.now())) {
            this.lockouts.remove(username);
            this.loginAttempts.remove(username);
            return false;
        }
        return true;
    }

    public static class Session {
        private final String sessionId;
        private final String username;
        private final LocalDateTime expiresAt;

        public Session(String sessionId, String username, LocalDateTime expiresAt) {
            this.sessionId = sessionId;
            this.username = username;
            this.expiresAt = expiresAt;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String getUsername() {
            return this.username;
        }

        public boolean isExpired() {
            return LocalDateTime.now().isAfter(this.expiresAt);
        }
    }
}

