/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.web.SessionManager;

public class StatsApiServlet
extends HttpServlet {
    private final WeGuardian plugin;
    private final SessionManager sessionManager;
    private final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)LocalDateTime.class), (src, typeOfSrc, context) -> context.serialize(src.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME))).create();

    public StatsApiServlet(WeGuardian plugin, SessionManager sessionManager) {
        this.plugin = plugin;
        this.sessionManager = sessionManager;
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sessionId = this.getSessionIdFromCookies(request);
        if (sessionId == null || !this.sessionManager.isValidSession(sessionId)) {
            response.setStatus(401);
            return;
        }
        response.setContentType("application/json");
        try {
            JsonObject stats = new JsonObject();
            CompletableFuture<List<Punishment>> future = this.plugin.getDatabaseManager().getAllActivePunishments();
            List<Punishment> activePunishments = future.join();
            if (this.plugin.getConfig().getBoolean("debug.enabled", false)) {
                this.plugin.getLogger().info("Found " + activePunishments.size() + " active punishments");
                for (Punishment p2 : activePunishments) {
                    this.plugin.getLogger().info("Punishment: " + p2.getTargetName() + " - " + String.valueOf((Object)p2.getType()) + " - Active: " + p2.isActive());
                }
            }
            int activeBans = (int)activePunishments.stream().filter(p -> p.getType().toString().contains("BAN")).count();
            int activeMutes = (int)activePunishments.stream().filter(p -> p.getType().toString().contains("MUTE")).count();
            stats.addProperty("active_bans", activeBans);
            stats.addProperty("active_mutes", activeMutes);
            stats.addProperty("total_punishments", activePunishments.size());
            stats.addProperty("online_players", this.plugin.getServer().getOnlinePlayers().size());
            stats.addProperty("server_name", this.plugin.getConfig().getString("server_name", "Unknown"));
            PrintWriter out = response.getWriter();
            out.print(this.gson.toJson(stats));
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error getting stats: " + e.getMessage());
            JsonObject error = new JsonObject();
            error.addProperty("error", "Failed to retrieve stats");
            response.setStatus(500);
            PrintWriter out = response.getWriter();
            out.print(this.gson.toJson(error));
        }
    }

    private String getSessionIdFromCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"sessionId".equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

