/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.exoconfig.client.screen;

import fr.tathan.exoconfig.ExoConfig;
import fr.tathan.exoconfig.client.components.ConfigList;
import fr.tathan.exoconfig.client.components.ConfigWidgetRegistry;
import fr.tathan.exoconfig.common.infos.ConfigInfos;
import fr.tathan.exoconfig.common.infos.ScreenInfos;
import fr.tathan.exoconfig.common.utils.Utils;
import fr.tathan.exoconfig.platform.PlatformHelper;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen<T>
extends Screen {
    private final Screen parent;
    public final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    protected ConfigList configList;
    public T configInstance;
    private final ConfigInfos configInfos;

    public ConfigScreen(Screen parent, T configInstance) {
        super((Component)Component.literal((String)"Config"));
        this.parent = parent;
        this.configInstance = configInstance;
        this.configInfos = Utils.getConfigInfos(configInstance.getClass());
    }

    protected void init() {
        this.addTitle();
        this.addFooter();
        this.configList = (ConfigList)this.layout.addToContents((LayoutElement)new ConfigList(this.minecraft, this.width, this));
        Class<?> clazz = this.configInstance.getClass();
        this.addFields(clazz.getFields(), this.configInstance, this.configList, 0);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.layout.arrangeElements();
    }

    protected void addTitle() {
        this.layout.addTitleHeader(this.title, this.font);
    }

    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(200).build());
    }

    private void addFields(Field[] fields, Object object, ConfigList configList, int recursionDepth) {
        for (Field field : fields) {
            try {
                if (field.isAnnotationPresent(ScreenInfos.Hidden.class)) continue;
                Object value = field.get(object);
                if (field.isAnnotationPresent(ScreenInfos.InnerConfig.class)) {
                    configList.addBig((AbstractWidget)this.getTitleWidget(field, true));
                    this.addFields(field.getType().getFields(), field.get(object), configList, recursionDepth + 1);
                    continue;
                }
                configList.addSmall((AbstractWidget)this.getTitleWidget(field, false), this.addTypeWidget(field, object, value, this.getWidgetDescription(field)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public StringWidget getTitleWidget(Field field, boolean title) {
        String name = field.getName();
        MutableComponent titleComponent = Component.translatable((String)("config." + this.configInfos.name() + "." + name));
        if (title) {
            titleComponent.withStyle(ChatFormatting.BOLD);
        }
        StringWidget stringWidget = new StringWidget((Component)titleComponent, this.font);
        stringWidget.setTooltip(Tooltip.create((Component)this.getWidgetDescription(field)));
        return stringWidget;
    }

    public Component getWidgetDescription(Field field) {
        if (field.isAnnotationPresent(ScreenInfos.Description.class)) {
            ScreenInfos.Description descriptionAnnotation = field.getAnnotation(ScreenInfos.Description.class);
            if (descriptionAnnotation.translate()) {
                return Component.translatable((String)descriptionAnnotation.value());
            }
            return Component.literal((String)descriptionAnnotation.value());
        }
        return Component.empty();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.configList != null) {
            this.configList.updateSize(this.width, this.layout);
        }
    }

    public void onClose() {
        this.saveConfig();
        this.playToast((Component)Component.literal((String)"Config Saved"), (Component)Component.literal((String)"The Stellaris config has been saved"));
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
    }

    public void removed() {
        this.minecraft.options.save();
    }

    public void playToast(Component title, Component description) {
        this.minecraft.getToastManager().addToast((Toast)new SystemToast(SystemToast.SystemToastId.PERIODIC_NOTIFICATION, title, description));
    }

    private AbstractWidget addTypeWidget(Field field, Object configInstance, Object value, Component description) {
        String fieldName = field.getName();
        if (ConfigWidgetRegistry.getInstance().componentExistForClass(value.getClass())) {
            return ConfigWidgetRegistry.getInstance().getComponentForClass(value.getClass()).apply(new ConfigWidgetRegistry.WidgetFactory(fieldName, configInstance, value, field, description, this));
        }
        if (value instanceof Enum) {
            return ConfigWidgetRegistry.getInstance().getComponentForClass(Enum.class).apply(new ConfigWidgetRegistry.WidgetFactory(fieldName, configInstance, value, field, description, this));
        }
        return ConfigWidgetRegistry.getInstance().getComponentForClass(Exception.class).apply(new ConfigWidgetRegistry.WidgetFactory(fieldName, configInstance, value, field, description, this));
    }

    private void saveConfig() {
        Path configPath = PlatformHelper.getConfigPath().resolve(this.getConfigName() + ".json");
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            ExoConfig.getGson().toJson(this.configInstance, this.configInstance.getClass(), (Appendable)writer);
        }
        catch (Exception e) {
            ExoConfig.LOG.error("Could not save config", (Throwable)e);
            this.playToast((Component)Component.literal((String)"Config Error"), (Component)Component.literal((String)("Failed to save " + this.getConfigName() + " config")));
        }
    }

    public void openUri() {
        Util.getPlatform().openUri(PlatformHelper.getConfigPath().resolve(this.getConfigName() + ".json").toUri());
    }

    public String getConfigName() {
        if (this.configInfos != null) {
            return this.configInfos.name();
        }
        return this.configInstance.getClass().getSimpleName();
    }
}

