/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.exoconfig.common.network;

import fr.tathan.exoconfig.ExoConfig;
import fr.tathan.exoconfig.common.loader.ConfigsRegistry;
import fr.tathan.exoconfig.common.utils.ConfigHolder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record SyncConfigPacket(String configName, String stringConfig) implements CustomPacketPayload
{
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"exoconfig", (String)"sync_config");
    public static final CustomPacketPayload.Type<SyncConfigPacket> TYPE = new CustomPacketPayload.Type(CHANNEL);
    public static final StreamCodec<FriendlyByteBuf, SyncConfigPacket> STREAM_CODEC = StreamCodec.ofMember(SyncConfigPacket::encode, SyncConfigPacket::new);

    public SyncConfigPacket(FriendlyByteBuf buf) {
        this(buf.readUtf(), buf.readUtf());
    }

    public CustomPacketPayload.Type<SyncConfigPacket> type() {
        return TYPE;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeUtf(this.configName);
        buf.writeUtf(this.stringConfig);
    }

    public static void handle(SyncConfigPacket packet) {
        ConfigHolder<?> oldHolder = ConfigsRegistry.getInstance().getConfig(packet.configName);
        if (oldHolder != null) {
            Object newConfig = ExoConfig.getGson().fromJson(packet.stringConfig, oldHolder.getConfig().getClass());
            oldHolder.setConfig(newConfig);
            ConfigsRegistry.getInstance().registerConfig(newConfig, oldHolder.getConfigInstance());
        }
    }
}

