/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.exoconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.TypeAdapterFactory;
import fr.tathan.exoconfig.common.Config;
import fr.tathan.exoconfig.common.infos.CommentTypeAdapter;
import fr.tathan.exoconfig.common.loader.ConfigsRegistry;
import fr.tathan.exoconfig.common.network.ProxyExclusionAdapterFactory;
import fr.tathan.exoconfig.common.network.SyncConfigPacket;
import fr.tathan.exoconfig.common.types.ConfigTypesRegistry;
import fr.tathan.exoconfig.common.types.RangedNumber;
import fr.tathan.exoconfig.common.types.ResourceLocationType;
import fr.tathan.exoconfig.platform.PlatformHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExoConfig {
    public static final String MOD_ID = "exoconfig";
    public static final Logger LOG = LoggerFactory.getLogger((String)"exoconfig");
    private static final GsonBuilder GSON = new GsonBuilder().setPrettyPrinting().setStrictness(Strictness.LENIENT).registerTypeAdapterFactory((TypeAdapterFactory)new CommentTypeAdapter()).registerTypeAdapterFactory((TypeAdapterFactory)new ProxyExclusionAdapterFactory()).setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE);
    public static Config EXO_CONFIG;

    public static void init() {
        ConfigTypesRegistry.register(RangedNumber.class, () -> new RangedNumber(0, 100, 50));
        ConfigTypesRegistry.register(class_2960.class, ResourceLocationType::serialize, ResourceLocationType::deserialize);
        ConfigTypesRegistry.registerAdapters(GSON);
        EXO_CONFIG = ConfigsRegistry.getInstance().registerConfig(new Config(), EXO_CONFIG);
    }

    public static Gson getGson() {
        return GSON.create();
    }

    public static void syncConfigs(class_3222 player, boolean joined) {
        if (joined) {
            ConfigsRegistry.getInstance().getConfigs().forEach((key, config) -> {
                if (config.isSyncable()) {
                    PlatformHelper.sendToClient(new SyncConfigPacket((String)key, ExoConfig.getGson().toJson(config)), player);
                }
            });
        }
    }
}

