/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.exoconfig.client.screen;

import fr.tathan.exoconfig.ExoConfig;
import fr.tathan.exoconfig.client.components.ConfigList;
import fr.tathan.exoconfig.client.components.ConfigWidgetRegistry;
import fr.tathan.exoconfig.common.infos.ConfigInfos;
import fr.tathan.exoconfig.common.infos.ScreenInfos;
import fr.tathan.exoconfig.common.utils.Utils;
import fr.tathan.exoconfig.platform.PlatformHelper;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8132;

public class ConfigScreen<T>
extends class_437 {
    private final class_437 parent;
    public final class_8132 layout = new class_8132((class_437)this);
    protected ConfigList configList;
    public T configInstance;
    private final ConfigInfos configInfos;

    public ConfigScreen(class_437 parent, T configInstance) {
        super((class_2561)class_2561.method_43470((String)"Config"));
        this.parent = parent;
        this.configInstance = configInstance;
        this.configInfos = Utils.getConfigInfos(configInstance.getClass());
    }

    protected void method_25426() {
        this.addTitle();
        this.addFooter();
        this.configList = (ConfigList)this.layout.method_48999((class_8021)new ConfigList(this.field_22787, this.field_22789, this));
        Class<?> clazz = this.configInstance.getClass();
        this.addFields(clazz.getFields(), this.configInstance, this.configList, 0);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.layout.method_48222();
    }

    protected void addTitle() {
        this.layout.method_57726(this.field_22785, this.field_22793);
    }

    protected void addFooter() {
        this.layout.method_48996((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46432(200).method_46431());
    }

    private void addFields(Field[] fields, Object object, ConfigList configList, int recursionDepth) {
        for (Field field : fields) {
            try {
                if (field.isAnnotationPresent(ScreenInfos.Hidden.class)) continue;
                Object value = field.get(object);
                if (field.isAnnotationPresent(ScreenInfos.InnerConfig.class)) {
                    configList.addBig((class_339)this.getTitleWidget(field, true));
                    this.addFields(field.getType().getFields(), field.get(object), configList, recursionDepth + 1);
                    continue;
                }
                configList.addSmall((class_339)this.getTitleWidget(field, false), this.addTypeWidget(field, object, value, this.getWidgetDescription(field)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class_7842 getTitleWidget(Field field, boolean title) {
        String name = field.getName();
        class_5250 titleComponent = class_2561.method_43471((String)("config." + this.configInfos.name() + "." + name));
        if (title) {
            titleComponent.method_27692(class_124.field_1067);
        }
        class_7842 stringWidget = new class_7842((class_2561)titleComponent, this.field_22793);
        stringWidget.method_47400(class_7919.method_47407((class_2561)this.getWidgetDescription(field)));
        return stringWidget;
    }

    public class_2561 getWidgetDescription(Field field) {
        if (field.isAnnotationPresent(ScreenInfos.Description.class)) {
            ScreenInfos.Description descriptionAnnotation = field.getAnnotation(ScreenInfos.Description.class);
            if (descriptionAnnotation.translate()) {
                return class_2561.method_43471((String)descriptionAnnotation.value());
            }
            return class_2561.method_43470((String)descriptionAnnotation.value());
        }
        return class_2561.method_43473();
    }

    protected void method_48640() {
        this.layout.method_48222();
        if (this.configList != null) {
            this.configList.method_57712(this.field_22789, this.layout);
        }
    }

    public void method_25419() {
        this.saveConfig();
        this.playToast((class_2561)class_2561.method_43470((String)"Config Saved"), (class_2561)class_2561.method_43470((String)"The Stellaris config has been saved"));
        this.field_22787.method_1507(this.parent);
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
    }

    public void method_25432() {
        this.field_22787.field_1690.method_1640();
    }

    public void playToast(class_2561 title, class_2561 description) {
        this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, title, description));
    }

    private class_339 addTypeWidget(Field field, Object configInstance, Object value, class_2561 description) {
        String fieldName = field.getName();
        if (ConfigWidgetRegistry.getInstance().componentExistForClass(value.getClass())) {
            return ConfigWidgetRegistry.getInstance().getComponentForClass(value.getClass()).apply(new ConfigWidgetRegistry.WidgetFactory(fieldName, configInstance, value, field, description, this));
        }
        if (value instanceof Enum) {
            return ConfigWidgetRegistry.getInstance().getComponentForClass(Enum.class).apply(new ConfigWidgetRegistry.WidgetFactory(fieldName, configInstance, value, field, description, this));
        }
        return ConfigWidgetRegistry.getInstance().getComponentForClass(Exception.class).apply(new ConfigWidgetRegistry.WidgetFactory(fieldName, configInstance, value, field, description, this));
    }

    private void saveConfig() {
        Path configPath = PlatformHelper.getConfigPath().resolve(this.getConfigName() + ".json");
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            ExoConfig.getGson().toJson(this.configInstance, this.configInstance.getClass(), (Appendable)writer);
        }
        catch (Exception e) {
            ExoConfig.LOG.error("Could not save config", (Throwable)e);
            this.playToast((class_2561)class_2561.method_43470((String)"Config Error"), (class_2561)class_2561.method_43470((String)("Failed to save " + this.getConfigName() + " config")));
        }
    }

    public void openUri() {
        class_156.method_668().method_673(PlatformHelper.getConfigPath().resolve(this.getConfigName() + ".json").toUri());
    }

    public String getConfigName() {
        if (this.configInfos != null) {
            return this.configInfos.name();
        }
        return this.configInstance.getClass().getSimpleName();
    }
}

