/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.exoconfig.common.infos;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import fr.tathan.exoconfig.common.infos.ConfigInfos;
import java.io.IOException;
import java.lang.reflect.Field;

public class CommentTypeAdapter
implements TypeAdapterFactory {
    private final FieldNamingStrategy fieldNamingStrategy;

    public CommentTypeAdapter(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy != null ? fieldNamingStrategy : FieldNamingPolicy.IDENTITY;
    }

    public CommentTypeAdapter() {
        this(null);
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        final Class raw = type.getRawType();
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                if (value == null) {
                    out.nullValue();
                    return;
                }
                JsonElement tree = delegate.toJsonTree(value);
                if (tree.isJsonObject()) {
                    JsonObject jsonObject = tree.getAsJsonObject();
                    for (Class current = raw; current != Object.class; current = current.getSuperclass()) {
                        for (Field field : current.getDeclaredFields()) {
                            if (!field.isAnnotationPresent(ConfigInfos.FileDescription.class)) continue;
                            ConfigInfos.FileDescription annotation = field.getAnnotation(ConfigInfos.FileDescription.class);
                            String comment = annotation.value();
                            String jsonFieldName = CommentTypeAdapter.this.fieldNamingStrategy.translateName(field);
                            String commentFieldName = jsonFieldName + "_comment";
                            jsonObject.addProperty(commentFieldName, comment);
                        }
                    }
                }
                Streams.write((JsonElement)tree, (JsonWriter)out);
            }

            public T read(JsonReader in) throws IOException {
                return delegate.read(in);
            }
        };
    }
}

