/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.exoconfig.client.components;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.NotNull;

public class EnumButton
extends AbstractButton {
    private static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));
    public String[] label;
    public Consumer<Integer> onPress;
    public Class<? extends Enum<?>> enumValue;
    public int index = 0;

    public EnumButton(int x, int y, int width, int height, Component message, Consumer<Integer> onPress, Class<? extends Enum<?>> enumValue, Object defaultValue) {
        super(x, y, width, height, message);
        this.onPress = onPress;
        this.label = EnumButton.getEnumValues(enumValue);
        this.enumValue = enumValue;
        this.setIndex(defaultValue);
    }

    public void nextValue() {
        ++this.index;
        if (this.index >= this.label.length) {
            this.index = 0;
        }
        this.onPress.accept(this.index);
    }

    @NotNull
    public Component getMessage() {
        return Component.literal((String)this.label[this.index]);
    }

    public void onPress() {
        this.nextValue();
        this.onPress.accept(this.index);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.renderString(guiGraphics, minecraft.font, ARGB.white((float)1.0f));
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void setIndex(Object defaultValue) {
        if (this.enumValue.isInstance(defaultValue)) {
            Enum<?>[] enumConstants = this.enumValue.getEnumConstants();
            for (int i = 0; i < enumConstants.length; ++i) {
                if (!enumConstants[i].equals(defaultValue)) continue;
                this.index = i;
                break;
            }
        }
    }

    public static Enum<?> getEnumValue(Class<? extends Enum<?>> enumClass, int index) {
        Enum<?>[] enumConstants = enumClass.getEnumConstants();
        if (index < 0 || index >= enumConstants.length) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for enum " + enumClass.getName());
        }
        return enumConstants[index];
    }

    public static String[] getEnumValues(Class<? extends Enum<?>> enumClass) {
        Enum<?>[] enumConstants = enumClass.getEnumConstants();
        String[] values = new String[enumConstants.length];
        for (int i = 0; i < enumConstants.length; ++i) {
            values[i] = enumConstants[i].name();
        }
        return values;
    }
}

