/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.exoconfig.client.components;

import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class RangedOption
extends AbstractSliderButton {
    public final double minValue;
    public final double maxValue;
    public final double step;
    public Consumer<RangedOption> onValueChange;

    public RangedOption(int x, int y, int width, int height, Component message, double minValue, double maxValue, double initialValue, double step, Consumer<RangedOption> onValueChange) {
        super(x, y, width, height, message, RangedOption.normalizeValue(initialValue, minValue, maxValue));
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
        this.onValueChange = onValueChange;
        this.updateMessage();
    }

    protected static double normalizeValue(double value, double min, double max) {
        return Mth.clamp((double)((value - min) / (max - min)), (double)0.0, (double)1.0);
    }

    protected static double denormalizeValue(double normalizedValue, double min, double max) {
        return min + normalizedValue * (max - min);
    }

    public void setValue(double rawValue) {
        this.value = RangedOption.normalizeValue(rawValue, this.minValue, this.maxValue);
        this.applyValue();
        this.updateMessage();
    }

    public double getCurrentValue() {
        double denormalizedValue = RangedOption.denormalizeValue(this.value, this.minValue, this.maxValue);
        return this.snapToStep(denormalizedValue);
    }

    protected double snapToStep(double value) {
        if (this.step == 0.0) {
            return value;
        }
        return (double)Math.round(value / this.step) * this.step;
    }

    public void setValueFromMouse(double mouseX) {
        super.setValueFromMouse(mouseX);
        this.value = RangedOption.normalizeValue(this.snapToStep(RangedOption.denormalizeValue(this.value, this.minValue, this.maxValue)), this.minValue, this.maxValue);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.canChangeValue) {
            boolean isRight;
            boolean isLeft = keyCode == 263;
            boolean bl = isRight = keyCode == 262;
            if (isLeft || isRight) {
                double currentValue = this.getCurrentValue();
                double newValue = currentValue + (isLeft ? -this.step : this.step);
                this.setValue(newValue);
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void updateMessage() {
        this.setMessage((Component)Component.literal((String)("" + this.getCurrentValue())));
    }

    protected void applyValue() {
        this.onValueChange.accept(this);
    }
}

