/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.exoconfig.client.components;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_357;

public class RangedOption
extends class_357 {
    public final double minValue;
    public final double maxValue;
    public final double step;
    public Consumer<RangedOption> onValueChange;

    public RangedOption(int x, int y, int width, int height, class_2561 message, double minValue, double maxValue, double initialValue, double step, Consumer<RangedOption> onValueChange) {
        super(x, y, width, height, message, RangedOption.normalizeValue(initialValue, minValue, maxValue));
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
        this.onValueChange = onValueChange;
        this.method_25346();
    }

    protected static double normalizeValue(double value, double min, double max) {
        return class_3532.method_15350((double)((value - min) / (max - min)), (double)0.0, (double)1.0);
    }

    protected static double denormalizeValue(double normalizedValue, double min, double max) {
        return min + normalizedValue * (max - min);
    }

    public void setValue(double rawValue) {
        this.field_22753 = RangedOption.normalizeValue(rawValue, this.minValue, this.maxValue);
        this.method_25344();
        this.method_25346();
    }

    public double getCurrentValue() {
        double denormalizedValue = RangedOption.denormalizeValue(this.field_22753, this.minValue, this.maxValue);
        return this.snapToStep(denormalizedValue);
    }

    protected double snapToStep(double value) {
        if (this.step == 0.0) {
            return value;
        }
        return (double)Math.round(value / this.step) * this.step;
    }

    public void method_25345(double mouseX) {
        super.method_25345(mouseX);
        this.field_22753 = RangedOption.normalizeValue(this.snapToStep(RangedOption.denormalizeValue(this.field_22753, this.minValue, this.maxValue)), this.minValue, this.maxValue);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_41796) {
            boolean isRight;
            boolean isLeft = keyCode == 263;
            boolean bl = isRight = keyCode == 262;
            if (isLeft || isRight) {
                double currentValue = this.getCurrentValue();
                double newValue = currentValue + (isLeft ? -this.step : this.step);
                this.setValue(newValue);
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_25346() {
        this.method_25355((class_2561)class_2561.method_43470((String)("" + this.getCurrentValue())));
    }

    protected void method_25344() {
        this.onValueChange.accept(this);
    }
}

