/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.exoconfig.common.loader;

import fr.tathan.exoconfig.ExoConfig;
import fr.tathan.exoconfig.common.infos.ConfigInfos;
import fr.tathan.exoconfig.common.utils.Utils;
import fr.tathan.exoconfig.platform.PlatformHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;

public class ConfigLoader {
    public static <T> T loadOrGenerateDefaults(Object config) {
        Path systemsFile = PlatformHelper.getConfigPath();
        Class<?> configClass = config.getClass();
        ConfigInfos configInfos = Utils.getConfigInfos(configClass);
        systemsFile = configInfos != null ? systemsFile.resolve(configInfos.name() + ".json") : PlatformHelper.getConfigPath().resolve(configClass.getName() + ".json");
        try {
            BufferedReader reader = Files.newBufferedReader(systemsFile);
            Object newConfig = ExoConfig.getGson().fromJson((Reader)reader, configClass);
            FileWriter writer = new FileWriter(systemsFile.toFile());
            ExoConfig.getGson().toJson(newConfig, (Appendable)writer);
            ((Writer)writer).close();
            return (T)newConfig;
        }
        catch (Exception e) {
            if (!(e instanceof NoSuchFileException)) {
                e.printStackTrace();
            }
            try {
                File folder = systemsFile.toFile().getParentFile();
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                FileWriter writer = new FileWriter(systemsFile.toFile());
                ExoConfig.getGson().toJson(config, (Appendable)writer);
                ((Writer)writer).close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return (T)config;
        }
    }
}

