/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.exoconfig.client;

import fr.tathan.exoconfig.ExoConfig;
import fr.tathan.exoconfig.client.ScreenUtils;
import fr.tathan.exoconfig.client.components.ConfigWidgetRegistry;
import fr.tathan.exoconfig.client.components.EnumButton;
import fr.tathan.exoconfig.client.components.RangedOption;
import fr.tathan.exoconfig.client.components.StateButton;
import fr.tathan.exoconfig.common.types.RangedNumber;
import fr.tathan.exoconfig.platform.PlatformHelperClient;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ExodusClient {
    public static Class<?>[] editBoxClass = new Class[]{Integer.class, Long.class, Double.class, Float.class, String.class, Number.class};

    public static void init() {
        PlatformHelperClient.registerConfigScreen("exoconfig", ExoConfig.EXO_CONFIG);
        ExodusClient.registerWidgetEntry();
    }

    public static void registerWidgetEntry() {
        ConfigWidgetRegistry.getInstance().registerComponent(Boolean.class, factory -> {
            StateButton button = new StateButton(0, 0, 150, 20, (Component)Component.literal((String)"StateButton"), (Boolean)factory.defaultValue(), b -> {
                try {
                    factory.field().set(factory.configInstance(), b);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            });
            if (ScreenUtils.showTooltip(factory.field())) {
                button.setTooltip(Tooltip.create((Component)factory.description()));
            }
            return button;
        });
        ConfigWidgetRegistry.getInstance().registerComponent(Enum.class, factory -> {
            EnumButton button = new EnumButton(0, 0, 150, 20, (Component)Component.literal((String)"EnumButton"), index -> {
                try {
                    factory.field().set(factory.configInstance(), EnumButton.getEnumValue(factory.defaultValue().getClass(), index));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }, factory.defaultValue().getClass(), factory.defaultValue());
            if (ScreenUtils.showTooltip(factory.field())) {
                button.setTooltip(Tooltip.create((Component)factory.description()));
            }
            return button;
        });
        ConfigWidgetRegistry.getInstance().registerComponent(RangedNumber.class, factory -> {
            RangedNumber number = (RangedNumber)factory.defaultValue();
            RangedOption button = new RangedOption(0, 0, 150, 20, (Component)Component.literal((String)"StateButton"), number.getMin().doubleValue(), number.getMax().doubleValue(), number.getValue().doubleValue(), 1.0, b -> {
                try {
                    factory.field().set(factory.configInstance(), new RangedNumber(number.getMin(), number.getMax(), b.getCurrentValue()));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            });
            if (ScreenUtils.showTooltip(factory.field())) {
                button.setTooltip(Tooltip.create((Component)factory.description()));
            }
            return button;
        });
        ConfigWidgetRegistry.getInstance().registerComponent(ResourceLocation.class, ScreenUtils::resourceLocationWidget);
        ConfigWidgetRegistry.getInstance().registerComponent(Exception.class, factory -> Button.builder((Component)Component.literal((String)"Open the config to edit"), b -> factory.configScreen().openUri()).build());
        for (Class<?> clazz : editBoxClass) {
            ConfigWidgetRegistry.getInstance().registerComponent(clazz, ScreenUtils::numberAndStringWidget);
        }
    }
}

