/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.exoconfig.common.post_validation;

import fr.tathan.exoconfig.common.infos.ConfigInfos;
import fr.tathan.exoconfig.common.post_validation.PostValidation;
import fr.tathan.exoconfig.common.types.ConfigType;
import java.lang.reflect.Field;

public class PostValidationUtils {
    public static <T> void postValidate(T configInstance) {
        Class<?> clazz = configInstance.getClass();
        Field[] fields = clazz.getFields();
        if (configInstance instanceof PostValidation) {
            PostValidation postValidation = (PostValidation)configInstance;
            postValidation.postValidation();
        }
        for (Field field : fields) {
            try {
                Object value = field.get(configInstance);
                if (value instanceof ConfigType) {
                    ConfigType configType = (ConfigType)value;
                    configType.postValidation();
                }
                if (value instanceof String) {
                    if (PostValidationUtils.checkPossibleStringValues(field, value)) continue;
                    PostValidationUtils.handleStringException(configInstance, field.getAnnotation(ConfigInfos.PossibleStringValues.class), field, value);
                    continue;
                }
                if (!(value instanceof Integer) || PostValidationUtils.checkPossibleIntValues(field, value)) continue;
                PostValidationUtils.handleIntException(configInstance, field.getAnnotation(ConfigInfos.PossibleIntValues.class), field, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to access field: " + field.getName(), e);
            }
        }
    }

    public static boolean checkPossibleStringValues(Field field, Object value) {
        if (field.isAnnotationPresent(ConfigInfos.PossibleStringValues.class)) {
            ConfigInfos.PossibleStringValues possibleValues = field.getAnnotation(ConfigInfos.PossibleStringValues.class);
            for (String possibleValue : possibleValues.value()) {
                if (!possibleValue.equals(value)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean checkPossibleIntValues(Field field, Object value) {
        if (field.isAnnotationPresent(ConfigInfos.PossibleIntValues.class)) {
            ConfigInfos.PossibleIntValues possibleValues = field.getAnnotation(ConfigInfos.PossibleIntValues.class);
            int[] nArray = possibleValues.value();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer possibleValue = nArray[i];
                if (!possibleValue.equals(value)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static <T> void handleStringException(T configInstance, ConfigInfos.PossibleStringValues stringValues, Field field, Object value) {
        ConfigInfos infos = configInstance.getClass().getAnnotation(ConfigInfos.class);
        switch (infos.errorHandling()) {
            case THROW_EXCEPTION: {
                throw new IllegalArgumentException("Invalid string value for field: " + field.getName() + ", value: " + String.valueOf(value));
            }
            case FIRST_VALUE: {
                try {
                    field.set(configInstance, stringValues.value()[0]);
                    break;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Unable to set field: " + field.getName(), e);
                }
            }
        }
    }

    public static <T> void handleIntException(T configInstance, ConfigInfos.PossibleIntValues intValues, Field field, Object value) {
        ConfigInfos infos = configInstance.getClass().getAnnotation(ConfigInfos.class);
        switch (infos.errorHandling()) {
            case THROW_EXCEPTION: {
                throw new IllegalArgumentException("Invalid string value for field: " + field.getName() + ", value: " + String.valueOf(value));
            }
            case FIRST_VALUE: {
                try {
                    field.set(configInstance, intValues.value()[0]);
                    break;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Unable to set field: " + field.getName(), e);
                }
            }
        }
    }
}

