/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.exoconfig.common.types;

import com.google.gson.internal.LazilyParsedNumber;
import fr.tathan.exoconfig.common.types.ConfigType;

public class RangedNumber
extends Number
implements ConfigType<RangedNumber> {
    private final Number min;
    private final Number max;
    public Number value;

    public RangedNumber(Number min, Number max, Number value) {
        this.min = min;
        this.max = max;
        this.value = value;
    }

    public Number getMin() {
        return this.min;
    }

    public Number getMax() {
        return this.max;
    }

    public Number getValue() {
        return this.value;
    }

    public boolean isInRange() {
        if (this.value instanceof Integer) {
            return (Integer)this.value >= (Integer)this.min && (Integer)this.value <= (Integer)this.max;
        }
        if (this.value instanceof Double) {
            return (Double)this.value >= (Double)this.min && (Double)this.value <= (Double)this.max;
        }
        if (this.value instanceof Float) {
            return ((Float)this.value).floatValue() >= ((Float)this.min).floatValue() && ((Float)this.value).floatValue() <= ((Float)this.max).floatValue();
        }
        if (this.value instanceof Long) {
            return (Long)this.value >= (Long)this.min && (Long)this.value <= (Long)this.max;
        }
        Number number = this.value;
        if (number instanceof LazilyParsedNumber) {
            LazilyParsedNumber number2 = (LazilyParsedNumber)number;
            return number2.doubleValue() >= this.min.doubleValue() && this.value.doubleValue() <= this.max.doubleValue();
        }
        throw new IllegalArgumentException("Unsupported number type: " + this.value.getClass().getName());
    }

    @Override
    public void postValidation() {
        if (!this.isInRange()) {
            this.value = this.min;
        }
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }
}

